Notebook[{

Cell[CellGroupData[{
Cell["\<\

Notebook reproducing the content of the paper xxx\
\>", "Subtitle",
 FontSize->24,ExpressionUUID->"b73ea991-a1e7-4945-91d0-4054ec287b18"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<xAct`xConf`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$PrePrint", "=", "ScreenDollarIndices"}], ";"}]}], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[1]:=",ExpressionUUID->"678b56c2-43ca-42da-a7c6-2d1dc4257ac4"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"a9f855b0-2534-4290-ab0e-be53f710be18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.3\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.3", ", ", {2015, 8, 23}],
  
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"b64bd0b0-55db-41ed-930a-cc73f3a46f4f"],

Cell[BoxData["\<\"CopyRight (C) 2003-2020, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"7663ac1b-a63d-41ba-923a-1ec5678a1b20"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"91c5fa90-a433-48c5-9e74-7fcb05ed6048"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"ccf0ecb7-605f-43fc-83b8-c486a429c534"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"2eb2ccc1-fad3-48d5-99fb-180c85c8d35c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "10", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.2.0", ", ", {2021, 10, 17}],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"ae9b804d-1bd5-4895-b4c5-71ba06171a23"],

Cell[BoxData["\<\"CopyRight (C) 2002-2021, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"c4c403fd-364d-4571-be09-2fbd860f14d1"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"eb549655-5a83-4e4f-9144-9571053ef896"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xConf`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.0.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "4", ",", "4"}], "}"}]}],
  SequenceForm["Package xAct`xConf`  version ", "0.0.1", ", ", {2025, 4, 4}],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"239f9aa0-6c3d-47d4-a146-82c3945094a8"],

Cell[BoxData["\<\"CopyRight (C) 2025-2026, Cyril Pitrou, Guillaume under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"385ad3d8-eae7-496e-b521-419295cf8b76"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"16f1b23f-8257-436b-8cb9-0f09e7282dc5"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"75f53661-3bc9-45ed-bacb-60af3549511f"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"dcfa16d4-bc91-4a1c-98eb-47e0de0513e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "AllowUpperDerivatives", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ContractMetric",
    "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", 
   "False", "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "** Option ", xAct`xTensor`AllowUpperDerivatives, " of ", 
   xAct`xTensor`ContractMetric, " changed from ", False, " to ", True],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"648270a4-ac2d-4b2f-9e55-c7b0f9bed93b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Option \"\>", "\[InvisibleSpace]", "UseMetricOnVBundle", 
   "\[InvisibleSpace]", "\<\" of \"\>", "\[InvisibleSpace]", "ToCanonical", 
   "\[InvisibleSpace]", "\<\" changed from \"\>", "\[InvisibleSpace]", "All", 
   "\[InvisibleSpace]", "\<\" to \"\>", "\[InvisibleSpace]", "None"}],
  SequenceForm[
  "** Option ", xAct`xTensor`UseMetricOnVBundle, " of ", 
   xAct`xTensor`ToCanonical, " changed from ", All, " to ", None],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[1]:=",ExpressionUUID->"e15b7c7c-f599-4ea1-b088-8b11c6d2d2a4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefManifold", "[", 
  RowBox[{"M", ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
    "\[Alpha]", ",", "\[Beta]", ",", "\[Mu]", ",", "\[Nu]", ",", 
     "\[Lambda]"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[3]:=",ExpressionUUID->"e5a250ec-cb66-4862-b7ba-440ac45c6456"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", "manifold ", $CellContext`M,
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"dad09c31-6edf-4952-bb99-5ebe9c59c061"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[3]:=",ExpressionUUID->"051d755d-71d5-4d05-94c0-460c0a820e2f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DefMetric", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], ",", 
      RowBox[{"-", "\[Beta]"}]}], "]"}], ",", "CD", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<;\>\"", ",", "\"\<\[Del]\>\""}], "}"}], ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<g\>\""}]}], "]"}], ";"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[4]:=",ExpressionUUID->"1b2706a6-c3c5-4973-9f84-2078f5461f09"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"8611b0f5-02b7-4995-a3e6-c02e9e61f189"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}], ",", 
     RowBox[{"-", "\[Mu]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda], -$CellContext`\[Mu]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"257d83c4-0fda-488f-b07e-2be138543760"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}], ",", 
     RowBox[{"-", "\[Mu]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda], -$CellContext`\[Mu]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"18f17d6f-465a-4a8d-a64b-b7e4d75a4584"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"Tetrag\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}], ",", 
     RowBox[{"-", "\[Mu]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`Tetrag\[Dagger][-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Lambda], -$CellContext`\[Mu]], ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"ddf9669b-96a3-4340-9d62-81fa4f9d4d36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"a678446f-2b0e-4af7-84a9-2e78e056d605"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"4efded5f-42dd-4174-b368-0d008d75ba66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"a7bc2c85-c09b-40ff-8940-e7248e1ee488"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}], ",", 
     RowBox[{"-", "\[Mu]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda], -$CellContext`\[Mu]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"1078e157-3d41-49aa-b1d9-216dff034067"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"9f2ae3d5-466b-40d9-b522-675356f92cff"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"20975722-087b-479a-ab15-f3c6edc39600"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"0699101d-eed8-4405-bc33-ad37b2766aa9"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"54a025ea-b4b5-43e5-bc5d-b3c346639182"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"0e033bd5-1843-4720-97e2-76a7504dc93c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}], ",", 
     RowBox[{"-", "\[Mu]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda], -$CellContext`\[Mu]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"b039c014-2a47-424e-9664-faacd1aa5851"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"933b0ed0-9c09-481a-8855-34d9bb7edd1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"29cbef60-30ea-4827-8e6a-cf1446f6d62e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"5aaf942f-13e5-457a-af78-27e282580051"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"62048c9e-c041-46fb-91a3-110fcc66dc86"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"3b616382-f8be-4396-a0b5-b912cb60e13e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[4]:=",ExpressionUUID->"ac14ed7e-6def-47b5-979a-ff24ccaaf969"]
}, Open  ]]
}, Open  ]],

Cell["\<\
We define several metrics which are conformally related to g.\
\>", "Text",ExpressionUUID->"7233aac8-9b37-4856-be3a-04f44c3e11f3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "DefConformalMetric"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[5]:=",ExpressionUUID->"e46bd726-9dfa-4c73-8ddb-0ea72171df84"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefConformalMetric[g,S] defines a metric \
conformally related to 'g', with the conformal factor 'S'. If other metrics \
are conformally related to 'g', then 'gS2' is related to them by transitivity \
of the conformal transformation. If the scalar field S[] does not exist, it \
is defined.\\n   Options are PrintAs->printasform, \
ConformalMetricName->MetricName, FrameColor->somecolor and \
SymbolOfCovD->{postfixsymbol,prefixsymbol}. If no ConformalMetricName is \
provided the name chosen is the concatenation 'metric+conformalfactor+2'. If \
no color is provided, it choses randomly a color. If no SymbolOfCovD is \
provided, the combination {:,\[Del]metricname} is chosen.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"DefConformalMetric", "[", "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DefConformalMetric", "::", "argm"}], 
                    "MessageName"], ",", "DefConformalMetric", ",", "0", ",", 
                    "2"}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DefConformalMetric", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`g_", "?", "MetricQ"}], ",", 
                    "xAct`xConf`Private`conffactor_", ",", 
                    RowBox[{"xAct`xConf`Private`options", ":", 
                    RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`nmetlist", ",", 
                    "xAct`xConf`Private`pas", ",", 
                    "xAct`xConf`Private`gconfnameraw", ",", 
                    "xAct`xConf`Private`cdgconf", ",", 
                    "xAct`xConf`Private`metlist", ",", 
                    "xAct`xConf`Private`color", ",", 
                    "xAct`xConf`Private`symbolscovd"}], "}"}], ",", 
                    RowBox[{"Catch", "[", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`M", "=", 
                    RowBox[{"ManifoldOfCovD", "[", 
                    
                    RowBox[{"CovDOfMetric", "[", "xAct`xConf`Private`g", 
                    "]"}], "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`CD", "=", 
                    
                    RowBox[{"CovDOfMetric", "[", "xAct`xConf`Private`g", 
                    "]"}]}]}], "}"}], ",", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`i1", "=", 
                    RowBox[{"DummyIn", "[", 
                    RowBox[{"Tangent", "[", "xAct`xConf`Private`M", "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`i2", "=", 
                    RowBox[{"DummyIn", "[", 
                    RowBox[{"Tangent", "[", "xAct`xConf`Private`M", "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`sy1", "=", 
                    RowBox[{
                    
                    RowBox[{"SymbolOfCovD", "[", "xAct`xConf`Private`CD", 
                    "]"}], "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"xAct`xConf`Private`sy2", "=", 
                    RowBox[{
                    
                    RowBox[{"SymbolOfCovD", "[", "xAct`xConf`Private`CD", 
                    "]"}], "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`metlist", "=", "$Metrics"}], 
                    ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`pas", ",", 
                    "xAct`xConf`Private`gconfnameraw", ",", 
                    "xAct`xConf`Private`color", ",", 
                    "xAct`xConf`Private`symbolscovd"}], "}"}], "=", 
                    RowBox[{"OptionValue", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"PrintAs", ",", "ConformalMetricName", ",", 
                    "FrameColor", ",", "SymbolOfCovD"}], "}"}], "]"}]}], ";", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`gconfnameraw", "===", 
                    "Automatic"}], ",", 
                    RowBox[{"xAct`xConf`Private`gconfnameraw", "=", 
                    RowBox[{"ConformalMetricName", "[", 
                    
                    RowBox[{"xAct`xConf`Private`g", ",", 
                    "xAct`xConf`Private`conffactor"}], "]"}]}]}], "]"}], ";", 
                    
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xConf`Private`gconfname", "=", 
                    "xAct`xConf`Private`gconfnameraw"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`cdgconf", "=", 
                    RowBox[{"SymbolJoin", "[", 
                    
                    RowBox[{"xAct`xConf`Private`CD", ",", 
                    "xAct`xConf`Private`gconfname"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"MetricQ", "[", "xAct`xConf`Private`gconfname", 
                    "]"}], ",", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DefConformalMetric", "::", "old"}], 
                    "MessageName"], ",", "xAct`xConf`Private`gconfname"}], 
                    "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`symbolscovd", "\[Equal]", 
                    "Automatic"}], ",", 
                    RowBox[{"xAct`xConf`Private`symbolscovd", "=", 
                    RowBox[{"{", 
                    RowBox[{"\":\"", ",", 
                    RowBox[{"\"\[Del]\"", "<>", 
                    
                    RowBox[{"ToString", "[", "xAct`xConf`Private`gconfname", 
                    "]"}]}]}], "}"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"xTensorQ", "[", "xAct`xConf`Private`gconfname", 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`pas", "===", "Automatic"}], 
                    ",", 
                    RowBox[{"xAct`xConf`Private`pas", "=", 
                    RowBox[{"\"[\"", "<>", 
                    RowBox[{"PrintAs", "[", "xAct`xConf`Private`g", "]"}], 
                    "<>", 
                    RowBox[{"(", 
                    RowBox[{"\"\\!\\(\"", "<>", 
                    
                    RowBox[{"PrintAs", "[", "xAct`xConf`Private`conffactor", 
                    "]"}], "<>", "\"\\^2\\)\""}], ")"}], "<>", "\"]\""}]}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`color", "===", "Automatic"}], 
                    ",", 
                    RowBox[{"xAct`xConf`Private`color", "=", 
                    RowBox[{"RandomColor", "[", "]"}]}]}], "]"}], ";", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"Choosing color \"", ",", 
                    "xAct`xConf`Private`color", ",", 
                    "\" for this conformal frame.\""}], "]"}], ";", 
                    RowBox[{
                    
                    RowBox[{"xAct`xConf`Private`ColorFrame", "[", 
                    "xAct`xConf`Private`gconfname", "]"}], "=", 
                    "xAct`xConf`Private`color"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"xTensorQ", "[", "xAct`xConf`Private`conffactor", 
                    "]"}]}], ",", 
                    RowBox[{"DefTensor", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], ",", 
                    
                    RowBox[{"{", "xAct`xConf`Private`M", "}"}], ",", 
                    RowBox[{"PrintAs", "\[Rule]", 
                    
                    RowBox[{"ToString", "[", "xAct`xConf`Private`conffactor", 
                    "]"}]}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"Off", "[", 
                    StyleBox[
                    RowBox[{"DefMetric", "::", "old"}], "MessageName"], "]"}],
                     ";", 
                    RowBox[{"DefMetric", "[", 
                    RowBox[{
                    
                    RowBox[{"SignDetOfMetric", "[", "xAct`xConf`Private`g", 
                    "]"}], ",", 
                    RowBox[{"xAct`xConf`Private`gconfname", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    "xAct`xConf`Private`cdgconf", ",", 
                    "xAct`xConf`Private`symbolscovd", ",", 
                    RowBox[{"PrintAs", "\[Rule]", "xAct`xConf`Private`pas"}], 
                    ",", 
                    RowBox[{"ConformalTo", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`g", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    SuperscriptBox[
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], 
                    "2"]}], "}"}]}]}], "]"}], ";", 
                    RowBox[{"DefInertHead", "[", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", 
                    "xAct`xConf`Private`gconfname", "]"}], ",", 
                    RowBox[{"ContractThrough", "\[Rule]", 
                    RowBox[{"{", "delta", "}"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"InertHeadQ", "[", 
                    
                    RowBox[{"ConformalFrame", "[", "xAct`xConf`Private`g", 
                    "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"DefInertHead", "[", 
                    RowBox[{
                    
                    RowBox[{"ConformalFrame", "[", "xAct`xConf`Private`g", 
                    "]"}], ",", 
                    RowBox[{"ContractThrough", "\[Rule]", 
                    RowBox[{"{", "delta", "}"}]}]}], "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    
                    RowBox[{"xAct`xConf`Private`gconfname", ",", 
                    "xAct`xConf`Private`g"}], "]"}], "=", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}], 
                    ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    
                    RowBox[{"xAct`xConf`Private`g", ",", 
                    "xAct`xConf`Private`gconfname"}], "]"}], "=", 
                    FractionBox["1", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]]}], 
                    ";", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ConformalFrame", "[", "_", "]"}], "[", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], 
                    "]"}], ":=", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}], 
                    ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    
                    RowBox[{"xAct`xConf`Private`g", ",", 
                    "xAct`xConf`Private`gconfname"}], "]"}], ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    
                    RowBox[{"xAct`xConf`Private`gconfname", ",", 
                    "xAct`xConf`Private`g"}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Catch", "[", 
                    RowBox[{"ConformalRules", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], "]"}],
                     "=!=", "Null"}], ",", 
                    RowBox[{
                    RowBox[{"SetConformalTo", "[", 
                    RowBox[{
                    RowBox[{"xAct`xConf`Private`gconfname", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{
                    RowBox[{"-", "xAct`xConf`Private`i1"}], ",", 
                    RowBox[{"-", "xAct`xConf`Private`i2"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"ConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], " ", 
                    SuperscriptBox[
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}], 
                    "2"]}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`gconfname", ",", "#1"}], 
                    "]"}], "=", 
                    RowBox[{
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], " ", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}]}], 
                    ";", 
                    RowBox[{"xAct`xConf`Private`gconfname", "/:", 
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"#1", ",", "xAct`xConf`Private`gconfname"}], 
                    "]"}], "=", 
                    FractionBox["1", 
                    RowBox[{
                    RowBox[{"SqrtConformalFactor", "[", 
                    RowBox[{"xAct`xConf`Private`g", ",", "#1"}], "]"}], " ", 
                    RowBox[{"xAct`xConf`Private`conffactor", "[", "]"}]}]]}], 
                    ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    RowBox[{"#1", ",", "xAct`xConf`Private`gconfname"}], 
                    "]"}], ";", 
                    RowBox[{"RulesChangeConformalFrame", "[", 
                    RowBox[{"xAct`xConf`Private`gconfname", ",", "#1"}], 
                    "]"}], ";"}]}], "]"}], "&"}], ")"}], "/@", 
                    "xAct`xConf`Private`metlist"}], ";"}]}], "]"}], ";"}]}], 
                    "]"}]}]}], "]"}]}], "]"}], "]"}]}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DefConformalMetric", "[", "_", "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"DefConformalMetric", "::", "argr"}], 
                    "MessageName"], ",", "DefConformalMetric", ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}, {
                   " "}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   PaneSelectorBox[{True->
                    ButtonBox[
                    PaneSelectorBox[{False->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "DownPointerOpener"]]},
                    "RowWithSeparators"], True->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "DownPointerOpenerHot"]]},
                    "RowWithSeparators"]}, Dynamic[
                    CurrentValue["MouseOver"]],
                    FrameMargins->0,
                    ImageSize->Automatic],
                    Appearance->None,
                    BaseStyle->None,
                    
                    ButtonFunction:>(Part[System`InformationDump`open$$, 3] = 
                    False),
                    Evaluator->Automatic,
                    FrameMargins->0,
                    ImageMargins->0,
                    Method->"Preemptive"], False->
                    ButtonBox[
                    PaneSelectorBox[{False->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "RightPointerOpener"]]},
                    "RowWithSeparators"], True->
                    TemplateBox[{"\[ThickSpace]", "\"\[ThickSpace]\"", 
                    StyleBox[
                    "\"Options\"", "InformationRowLabel", StripOnInput -> 
                    False], 
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "RightPointerOpenerHot"]]},
                    "RowWithSeparators"]}, Dynamic[
                    CurrentValue["MouseOver"]],
                    FrameMargins->0,
                    ImageSize->Automatic],
                    Appearance->None,
                    BaseStyle->None,
                    
                    ButtonFunction:>(Part[System`InformationDump`open$$, 3] = 
                    True),
                    Evaluator->Automatic,
                    FrameMargins->0,
                    ImageMargins->0,
                    Method->"Preemptive"]}, Dynamic[
                    FEPrivate`Part[System`InformationDump`open$$, 3]]], 
                   PaneSelectorBox[{True->GridBox[{
                    {
                    RowBox[{"PrintAs", "\[Rule]", "Automatic"}]},
                    {
                    RowBox[{"ConformalMetricName", "\[Rule]", "Automatic"}]},
                    {
                    RowBox[{"FrameColor", "\[Rule]", "Automatic"}]},
                    {
                    RowBox[{"SymbolOfCovD", "\[Rule]", "Automatic"}]},
                    {
                    StyleBox[
                    
                    TemplateBox[{
                    "\"(\"", "\"\[InvisibleSpace]\"", "4", "\" total)\""},
                    "RowDefault"], "InformationRowOpener",
                    StripOnInput->False]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{1.}}}], False->
                    RowBox[{
                    RowBox[{"PrintAs", "\[Rule]", "Automatic"}], 
                    "\[ThinSpace]", 
                    StyleBox["\<\"\[Ellipsis]\"\>", "InformationRowOpener",
                    StripOnInput->False], "\[ThinSpace]", 
                    StyleBox[
                    
                    TemplateBox[{
                    "\"(\"", "\"\[InvisibleSpace]\"", "4", "\" total)\""},
                    "RowDefault"], "InformationRowOpener",
                    StripOnInput->False]}]}, Dynamic[
                    FEPrivate`Part[System`InformationDump`open$$, 3]],
                    BaselinePosition->Baseline,
                    ImageSize->Automatic]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xConf`DefConformalMetric\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefConformalMetric[g,S] defines a metric \
conformally related to 'g', with the conformal factor 'S'. If other metrics \
are conformally related to 'g', then 'gS2' is related to them by transitivity \
of the conformal transformation. If the scalar field S[] does not exist, it \
is defined.\\n   Options are PrintAs->printasform, \
ConformalMetricName->MetricName, FrameColor->somecolor and \
SymbolOfCovD->{postfixsymbol,prefixsymbol}. If no ConformalMetricName is \
provided the name chosen is the concatenation 'metric+conformalfactor+2'. If \
no color is provided, it choses randomly a color. If no SymbolOfCovD is \
provided, the combination {:,\[Del]metricname} is chosen.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DefConformalMetric[g,S] defines a metric conformally related to 'g', \
with the conformal factor 'S'. If other metrics are conformally related to \
'g', then 'gS2' is related to them by transitivity of the conformal \
transformation. If the scalar field S[] does not exist, it is defined.\n   \
Options are PrintAs->printasform, ConformalMetricName->MetricName, \
FrameColor->somecolor and SymbolOfCovD->{postfixsymbol,prefixsymbol}. If no \
ConformalMetricName is provided the name chosen is the concatenation \
'metric+conformalfactor+2'. If no color is provided, it choses randomly a \
color. If no SymbolOfCovD is provided, the combination {:,\[Del]metricname} \
is chosen.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None,
     "DownValues" -> 
    Information`InformationValueForm[
     DownValues, xAct`xConf`DefConformalMetric, {
      xAct`xConf`DefConformalMetric[] :> Message[
         MessageName[xAct`xConf`DefConformalMetric, "argm"], 
         xAct`xConf`DefConformalMetric, 0, 2], xAct`xConf`DefConformalMetric[
         PatternTest[
          Pattern[xAct`xConf`Private`g, 
           Blank[]], xAct`xTensor`MetricQ], 
         Pattern[xAct`xConf`Private`conffactor, 
          Blank[]], 
         Pattern[xAct`xConf`Private`options, 
          OptionsPattern[]]] :> 
       Module[{xAct`xConf`Private`nmetlist, xAct`xConf`Private`pas, 
          xAct`xConf`Private`gconfnameraw, xAct`xConf`Private`cdgconf, 
          xAct`xConf`Private`metlist, xAct`xConf`Private`color, 
          xAct`xConf`Private`symbolscovd}, 
         Catch[
          With[{xAct`xConf`Private`M = xAct`xTensor`ManifoldOfCovD[
              xAct`xTensor`CovDOfMetric[xAct`xConf`Private`g]], 
            xAct`xConf`Private`CD = 
            xAct`xTensor`CovDOfMetric[xAct`xConf`Private`g]}, 
           With[{xAct`xConf`Private`i1 = xAct`xTensor`DummyIn[
               xAct`xTensor`Tangent[xAct`xConf`Private`M]], 
             xAct`xConf`Private`i2 = xAct`xTensor`DummyIn[
               xAct`xTensor`Tangent[xAct`xConf`Private`M]], 
             xAct`xConf`Private`sy1 = Part[
               xAct`xTensor`SymbolOfCovD[xAct`xConf`Private`CD], 1], 
             xAct`xConf`Private`sy2 = Part[
               xAct`xTensor`SymbolOfCovD[xAct`xConf`Private`CD], 2]}, 
            xAct`xConf`Private`metlist = 
             xAct`xTensor`$Metrics; {
              xAct`xConf`Private`pas, xAct`xConf`Private`gconfnameraw, 
               xAct`xConf`Private`color, xAct`xConf`Private`symbolscovd} = 
             OptionValue[{
               xAct`xTensor`PrintAs, xAct`xConf`ConformalMetricName, 
                xAct`xConf`FrameColor, xAct`xTensor`SymbolOfCovD}]; 
            If[xAct`xConf`Private`gconfnameraw === Automatic, 
              xAct`xConf`Private`gconfnameraw = 
              xAct`xConf`ConformalMetricName[
               xAct`xConf`Private`g, xAct`xConf`Private`conffactor]]; 
            With[{xAct`xConf`Private`gconfname = 
               xAct`xConf`Private`gconfnameraw}, 
              xAct`xConf`Private`cdgconf = 
               xAct`xCore`SymbolJoin[
                xAct`xConf`Private`CD, xAct`xConf`Private`gconfname]; If[
                xAct`xTensor`MetricQ[xAct`xConf`Private`gconfname], 
                Message[
                 MessageName[xAct`xConf`DefConformalMetric, "old"], 
                 xAct`xConf`Private`gconfname]]; 
              If[xAct`xConf`Private`symbolscovd == Automatic, 
                xAct`xConf`Private`symbolscovd = {
                 ":", "\[Del]" <> ToString[xAct`xConf`Private`gconfname]}]; If[
                Not[
                 xAct`xTensor`xTensorQ[xAct`xConf`Private`gconfname]], 
                If[xAct`xConf`Private`pas === Automatic, 
                  xAct`xConf`Private`pas = 
                  "[" <> xAct`xTensor`PrintAs[xAct`xConf`Private`g] <> (
                    "\!\(" <> xAct`xTensor`PrintAs[
                    xAct`xConf`Private`conffactor] <> "\^2\)") <> "]"]; 
                If[xAct`xConf`Private`color === Automatic, 
                  xAct`xConf`Private`color = RandomColor[]]; 
                Print["Choosing color ", xAct`xConf`Private`color, 
                  " for this conformal frame."]; 
                xAct`xConf`Private`ColorFrame[xAct`xConf`Private`gconfname] = 
                 xAct`xConf`Private`color; If[
                  Not[
                   xAct`xTensor`xTensorQ[xAct`xConf`Private`conffactor]], 
                  xAct`xTensor`DefTensor[
                   xAct`xConf`Private`conffactor[], {xAct`xConf`Private`M}, 
                   xAct`xTensor`PrintAs -> 
                   ToString[xAct`xConf`Private`conffactor]]]; Off[
                  MessageName[xAct`xTensor`DefMetric, "old"]]; 
                xAct`xTensor`DefMetric[
                  xAct`xTensor`SignDetOfMetric[xAct`xConf`Private`g], 
                  
                  xAct`xConf`Private`gconfname[-xAct`xConf`Private`i1, -
                   xAct`xConf`Private`i2], xAct`xConf`Private`cdgconf, 
                  xAct`xConf`Private`symbolscovd, xAct`xTensor`PrintAs -> 
                  xAct`xConf`Private`pas, xAct`xTensor`ConformalTo -> {
                    xAct`xConf`Private`g[-xAct`xConf`Private`i1, -
                    xAct`xConf`Private`i2], 
                    xAct`xConf`Private`conffactor[]^2}]; 
                xAct`xTensor`DefInertHead[
                  xAct`xConf`ConformalFrame[xAct`xConf`Private`gconfname], 
                  xAct`xTensor`ContractThrough -> {xAct`xTensor`delta}]; If[
                  Not[
                   xAct`xTensor`InertHeadQ[
                    xAct`xConf`ConformalFrame[xAct`xConf`Private`g]]], 
                  xAct`xTensor`DefInertHead[
                    xAct`xConf`ConformalFrame[xAct`xConf`Private`g], 
                    xAct`xTensor`ContractThrough -> {xAct`xTensor`delta}]; 
                  Null]; TagSet[xAct`xConf`Private`gconfname, 
                  xAct`xConf`SqrtConformalFactor[
                  xAct`xConf`Private`gconfname, xAct`xConf`Private`g], 
                  xAct`xConf`Private`conffactor[]]; 
                TagSet[xAct`xConf`Private`gconfname, 
                  xAct`xConf`SqrtConformalFactor[
                  xAct`xConf`Private`g, xAct`xConf`Private`gconfname], 1/
                  xAct`xConf`Private`conffactor[]]; 
                xAct`xConf`ConformalFrame[
                   Blank[]][
                   xAct`xConf`Private`conffactor[]] := 
                 xAct`xConf`Private`conffactor[]; 
                xAct`xConf`RulesChangeConformalFrame[
                 xAct`xConf`Private`g, xAct`xConf`Private`gconfname]; 
                xAct`xConf`RulesChangeConformalFrame[
                 xAct`xConf`Private`gconfname, xAct`xConf`Private`g]; 
                Map[If[Catch[
                    xAct`xTensor`ConformalRules[xAct`xConf`Private`g, #]] =!= 
                   Null, xAct`xTensor`SetConformalTo[
                    
                    xAct`xConf`Private`gconfname[-xAct`xConf`Private`i1, -
                    xAct`xConf`Private`i2], {
                    #[-xAct`xConf`Private`i1, -xAct`xConf`Private`i2], 
                    xAct`xTensor`ConformalFactor[xAct`xConf`Private`g, #] 
                    xAct`xConf`Private`conffactor[]^2}]; 
                   TagSet[xAct`xConf`Private`gconfname, 
                    xAct`xConf`SqrtConformalFactor[
                    xAct`xConf`Private`gconfname, #], 
                    xAct`xConf`SqrtConformalFactor[xAct`xConf`Private`g, #] 
                    xAct`xConf`Private`conffactor[]]; 
                   TagSet[xAct`xConf`Private`gconfname, 
                    
                    xAct`xConf`SqrtConformalFactor[#, 
                    xAct`xConf`Private`gconfname], 1/(
                    xAct`xConf`SqrtConformalFactor[xAct`xConf`Private`g, #] 
                    xAct`xConf`Private`conffactor[])]; 
                   xAct`xConf`RulesChangeConformalFrame[#, 
                    xAct`xConf`Private`gconfname]; 
                   xAct`xConf`RulesChangeConformalFrame[
                    xAct`xConf`Private`gconfname, #]; Null]& , 
                  xAct`xConf`Private`metlist]; Null]; Null]]]]], 
       xAct`xConf`DefConformalMetric[
         Blank[]] :> Message[
         MessageName[xAct`xConf`DefConformalMetric, "argr"], 
         xAct`xConf`DefConformalMetric, {2, 
          DirectedInfinity[1]}]}], "SubValues" -> None, "DefaultValues" -> 
    None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {
     xAct`xTensor`PrintAs -> Automatic, xAct`xConf`ConformalMetricName -> 
      Automatic, xAct`xConf`FrameColor -> Automatic, 
      xAct`xTensor`SymbolOfCovD -> Automatic}, "Attributes" -> {Protected}, 
    "FullName" -> "xAct`xConf`DefConformalMetric"|>, False]]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[5]=",ExpressionUUID->"d5c77e7c-d1a9-4aac-8243-8204e60f361e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefConformalMetric", "[", 
  RowBox[{"g", ",", "S", ",", 
   RowBox[{"PrintAs", "->", "\"\<G\>\""}], ",", 
   RowBox[{"ConformalMetricName", "->", "G"}], ",", 
   RowBox[{"SymbolOfCovD", "->", 
    RowBox[{"{", 
     RowBox[{
     "\"\<:\>\"", ",", "\"\<\!\(\*OverscriptBox[\(\[Del]\), \(G\)]\)\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[6]:=",ExpressionUUID->"5fd15a73-c93c-4f82-9220-eae3263c5564"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Choosing color \"\>", "\[InvisibleSpace]", 
   TemplateBox[<|
    "color" -> RGBColor[
      0.29199748343883414`, 0.297614596521381, 0.8641642260014144]|>,
    "RGBColorSwatchTemplate"], 
   "\[InvisibleSpace]", "\<\" for this conformal frame.\"\>"}],
  SequenceForm["Choosing color ", 
   RGBColor[0.29199748343883414`, 0.297614596521381, 0.8641642260014144], 
   " for this conformal frame."],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"1462846b-b5a2-4ce7-a2e7-2afca4c71772"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"8ff950a8-950a-4341-ab31-2e1a91c3d7af"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"G", "[", 
    RowBox[{
     RowBox[{"-", "\[Lambda]$4434"}], ",", 
     RowBox[{"-", "\[Lambda]$4435"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`G[-$CellContext`\[Lambda]$4434, -$CellContext`\[Lambda]$4435],
    ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"4b80b02a-a148-471c-ab24-b08dd2277d67"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inverse metric tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"InvG", "[", 
    RowBox[{"\[Lambda]$4434", ",", "\[Lambda]$4435"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Metric is frozen!\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "inverse metric tensor ", 
   $CellContext`InvG[$CellContext`\[Lambda]$4434, \
$CellContext`\[Lambda]$4435], ". ", "Metric is frozen!"],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"428d0271-c790-4ff2-b0be-d450f760c0be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilonG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}], ",", 
     RowBox[{"-", "\[Lambda]1"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilonG[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda], -$CellContext`\[Lambda]1], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"41a6963e-3492-4988-bef4-5e69ae1967a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetraG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}], ",", 
     RowBox[{"-", "\[Lambda]1"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetraG[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda], -$CellContext`\[Lambda]1], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"0ca197e1-caca-455b-9658-af20c9e39e09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tetrametric \"\>", "\[InvisibleSpace]", 
   RowBox[{"TetraG\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}], ",", 
     RowBox[{"-", "\[Lambda]1"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tetrametric ", 
   $CellContext`TetraG\[Dagger][-$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Lambda], -$CellContext`\[Lambda]1], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"c491d4b0-b3b8-4588-9503-98a18f675407"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDG", "[", 
    RowBox[{"-", "\[Lambda]$4434"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDG[-$CellContext`\[Lambda]$4434], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"88f6ed1e-3180-4b9b-8255-b27cda0a106e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCDG", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCDG[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"dc6fc414-fe06-45b7-87aa-42076caabb85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDG", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCDG[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"f36955b8-a73a-488b-8186-272500d0b7c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannDownCDG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}], ",", 
     RowBox[{"-", "\[Lambda]1"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannDownCDG[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda], -$CellContext`\[Lambda]1], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"306a3149-54f4-40f7-8097-b79e510264a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCDG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}], ",", "\[Lambda]1"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCDG[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda], $CellContext`\[Lambda]1], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"f1f82959-9b95-422f-9949-35636ac74cb4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCDG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCDG[-$CellContext`\[Alpha], -$CellContext`\[Beta]], ". ",
    ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"f443a50c-5196-483c-a9cf-21affa8a8b27"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"d436bfad-2220-48b9-a4c4-efa7c643d381"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCDG", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCDG[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"1f40ace3-8a8d-4034-8bb0-337709183e63"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"59692fc0-9f1e-4328-ad25-74d5f96d3eb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCDG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCDG[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"40099a86-6d05-47ee-b0a9-fba2df572739"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCDG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}], ",", 
     RowBox[{"-", "\[Lambda]1"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "Weyl tensor ", 
   $CellContext`WeylCDG[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda], -$CellContext`\[Lambda]1], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"d32879ea-8647-45cc-8f0c-9915b7aa1563"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCDG", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCDG[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"08c3d974-8065-4291-b0c2-cdfd02604729"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCDG", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCDG[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"cc96b8f0-2b1e-4f11-9feb-b136cd2f240a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"5ede44f0-937c-4640-9fb0-8f753b3c3227"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "4"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 4],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"1b124249-fd5d-4883-9084-8712d63ee180"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"DetG", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`DetG[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"aea10ea0-b128-4d0f-9be1-0760e79ea560"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "G", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`G], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"32ce5836-74ad-4eec-8a3f-6e2c1cc0c7a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", 
   RowBox[{"ConformalFrame", "[", "g", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefInertHead, ": Defining ", "inert head ", 
   xAct`xConf`ConformalFrame[$CellContext`g], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[6]:=",ExpressionUUID->"f177efa2-4990-45c4-9620-f086d3a7d820"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Metrics"], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[7]:=",ExpressionUUID->"035a2530-fef1-40c7-93eb-141dc6dbe2ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"g", ",", "G"}], "}"}]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[7]=",ExpressionUUID->"ca5f2e70-463d-4970-b085-daf388fc1643"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConformalRules", "[", 
  RowBox[{"G", ",", "g"}], "]"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[8]:=",ExpressionUUID->"ceb81265-5e81-4ee7-94b1-7498416bbcd8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"G", 
         StyleBox[GridBox[{
            {
             UnderscriptBox["\[Alpha]", "_"], 
             UnderscriptBox["\[Beta]", "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`G[
      Pattern[$CellContext`\[Alpha], 
       Blank[]], 
      Pattern[$CellContext`\[Beta], 
       Blank[]]],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "2"]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"iG", 
         StyleBox[GridBox[{
            {
             UnderscriptBox["\[Alpha]", "_"], 
             UnderscriptBox["\[Beta]", "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`InvG[
      Pattern[$CellContext`\[Alpha], 
       Blank[]], 
      Pattern[$CellContext`\[Beta], 
       Blank[]]],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "2"]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["G", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`DetG[],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[
       OverscriptBox["g", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`Detg[],
      Editable->False], " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "8"]}]}]}], "}"}]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[8]=",ExpressionUUID->"8f357142-0fa5-4424-a27d-8177204d0058"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], ",", 
   RowBox[{"{", "M", "}"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<k\>\""}]}], "]"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[9]:=",ExpressionUUID->"cc2b177e-d283-4b5d-9675-56e700b20c97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`k[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[9]:=",ExpressionUUID->"045149cb-46bd-4e56-8e69-76af6810a56f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ConformalWeight", "[", "k", "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"k", "[", 
   RowBox[{"-", "\[Alpha]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"k", "[", "\[Alpha]", "]"}], "]"}]}], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[10]:=",ExpressionUUID->"c7c1cd5e-e961-4cda-b21c-78716f66e6ec"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[10]=",ExpressionUUID->"1a4994d7-3743-40e5-be0b-777ea27c177a"],

Cell[BoxData["1"], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[11]=",ExpressionUUID->"0faca9e3-22e6-4c0d-b83b-a25deb4b443d"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[12]=",ExpressionUUID->"b1d18c0c-1120-4eea-b8bd-4d8fb3dfa477"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$FormatConformal", " ", "=", " ", "\"\<Default\>\""}], 
  ";"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[13]:=",ExpressionUUID->"7b1bfe76-4838-4510-851a-8bddc0e05304"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConformalFrame", "[", "g", "]"}], "[", 
  RowBox[{"k", "[", 
   RowBox[{"-", "\[Beta]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalFrame", "[", "G", "]"}], "[", 
  RowBox[{"k", "[", 
   RowBox[{"-", "\[Beta]"}], "]"}], "]"}]}], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[14]:=",ExpressionUUID->"d5429da5-b2bf-4541-a978-b0e6896d6484"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox[
     OverscriptBox["\[Null]", "g"],
     FontSize->8], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Beta]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Beta]],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`g][
   $CellContext`k[-$CellContext`\[Beta]]],
  Editable->False]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[14]=",ExpressionUUID->"0cf73396-a2ac-49c8-9222-fa8a49470c36"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox[
     OverscriptBox["\[Null]", "G"],
     FontSize->8], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Beta]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Beta]],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xConf`ConformalFrame[$CellContext`G][
   $CellContext`k[-$CellContext`\[Beta]]],
  Editable->False]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[15]=",ExpressionUUID->"571d965a-314d-4953-839d-3e2bb0071550"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConformalFrame", "[", "G", "]"}], "[", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "[", 
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Beta]"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[16]:=",ExpressionUUID->"38641060-3707-4be2-9f1e-891f75bedecb"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox[
     OverscriptBox["\[Del]", "G"], "\[Alpha]"], 
    StyleBox[
     OverscriptBox["\[Null]", "G"],
     FontSize->8], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Beta]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Beta]],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CDG[-$CellContext`\[Alpha]][
   xAct`xConf`ConformalFrame[$CellContext`G][
    $CellContext`k[-$CellContext`\[Beta]]]],
  Editable->False]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[16]=",ExpressionUUID->"27b8adc1-6c74-479e-bcde-335c159feeb4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"LogS", "[", "]"}], ",", "M", ",", 
   RowBox[{"PrintAs", "->", "\"\<ln(S)\>\""}]}], "]"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[17]:=",ExpressionUUID->"de68dcc3-5685-49bd-86bc-3047b6146f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"LogS", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`LogS[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[17]:=",ExpressionUUID->"9fea6af0-8104-4c98-881b-4157c7d60ca7"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"RuleLogS", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"cd_", "?", "CovDQ"}], "[", "i_", "]"}], "[", 
      RowBox[{"S", "[", "]"}], "]"}], ":>", 
     RowBox[{
      RowBox[{"S", "[", "]"}], 
      RowBox[{
       RowBox[{"cd", "[", "i", "]"}], "[", 
       RowBox[{"LogS", "[", "]"}], "]"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[18]:=",ExpressionUUID->"e673f299-cc5a-4b72-909e-152bb593fe0e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"S", "[", "]"}], 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "\[Mu]"}], "]"}], "[", 
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Beta]"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToMetric", "[", "G", "]"}], "[", "%", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"%", "//", "NoScalar"}], ")"}], "/.", "RuleLogS"}], 
  "]"}]}], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[19]:=",ExpressionUUID->"e5c9b919-3bb4-4a5a-8357-9ae6853b365c"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox["S",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "\[Mu]"], GridBox[{
       {"k", 
        StyleBox[GridBox[{
           {" "},
           {"\[Beta]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`\[Mu]][
    $CellContext`k[-$CellContext`\[Beta]]],
   Editable->False]}]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[19]=",ExpressionUUID->"26c1f48c-07c7-4313-94fa-d882c4b31f54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDCDG", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelCDCDG[$CellContext`\[Alpha], \
-$CellContext`\[Beta], -$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[19]:=",ExpressionUUID->"081417e5-55ad-4c26-be3c-52281d00bda0"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox[
      OverscriptBox["\[Del]", "G"], "\[Mu]"], 
     StyleBox[
      OverscriptBox["\[Null]", "G"],
      FontSize->8], "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"k", 
          StyleBox[GridBox[{
             {" "},
             {"\[Beta]"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`k[-$CellContext`\[Beta]],
      Editable->False], "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CDG[-$CellContext`\[Mu]][
    xAct`xConf`ConformalFrame[$CellContext`G][
     $CellContext`k[-$CellContext`\[Beta]]]],
   Editable->False], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"G", 
        StyleBox[GridBox[{
           {" ", " "},
           {"\[Beta]", "\[Mu]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`G[-$CellContext`\[Beta], -$CellContext`\[Mu]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"iG", 
        StyleBox[GridBox[{
           {"\[Alpha]", "\[Lambda]"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InvG[$CellContext`\[Alpha], $CellContext`\[Lambda]],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Del]", "G"], "\[Lambda]"], 
       RowBox[{"ln", 
        RowBox[{"(", "S", ")"}]}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDG[-$CellContext`\[Lambda]][
      $CellContext`LogS[]],
     Editable->False], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox[
       OverscriptBox["\[Null]", "G"],
       FontSize->8], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"k", 
           StyleBox[GridBox[{
              {" "},
              {"\[Alpha]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`k[-$CellContext`\[Alpha]],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xConf`ConformalFrame[$CellContext`G][
     $CellContext`k[-$CellContext`\[Alpha]]],
    Editable->False]}], "+", 
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox[
        OverscriptBox["\[Del]", "G"], "\[Beta]"], 
       RowBox[{"ln", 
        RowBox[{"(", "S", ")"}]}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDG[-$CellContext`\[Beta]][
      $CellContext`LogS[]],
     Editable->False], ")"}], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      StyleBox[
       OverscriptBox["\[Null]", "G"],
       FontSize->8], "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"k", 
           StyleBox[GridBox[{
              {" "},
              {"\[Mu]"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "Rows" -> {{
                  Offset[0.]}}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`k[-$CellContext`\[Mu]],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xConf`ConformalFrame[$CellContext`G][
     $CellContext`k[-$CellContext`\[Mu]]],
    Editable->False]}]}]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[21]=",ExpressionUUID->"aa0c72f5-93ee-4018-bb38-81d122d9293a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "G"}], "]"}], "[", 
  RowBox[{"k", "[", 
   RowBox[{"-", "\[Alpha]"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "G"}], "]"}], "[", 
  RowBox[{"k", "[", "\[Alpha]", "]"}], "]"}]}], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[22]:=",ExpressionUUID->"c4034a3d-145e-4733-b8ff-488ad136f6c2"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"k", 
       StyleBox[GridBox[{
          {" "},
          {"\[Alpha]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`k[-$CellContext`\[Alpha]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox["S",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[],
   Editable->False]}]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[22]=",ExpressionUUID->"15f664cd-95d5-4b6e-a926-0458cc79bee6"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"\[Alpha]", "\[Beta]"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"k", 
        StyleBox[GridBox[{
           {" "},
           {"\[Beta]"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "Rows" -> {{
               Offset[0.]}}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`k[-$CellContext`\[Beta]],
    Editable->False]}], 
  InterpretationBox[
   StyleBox["S",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[],
   Editable->False]]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[23]=",ExpressionUUID->"d0dc7711-fee3-4550-85e8-6a16beda6343"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContractMetric", "[", "%", "]"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[24]:=",ExpressionUUID->"61049bb8-58c7-479c-8dcb-da195d3e61d2"],

Cell[BoxData[
 FractionBox[
  InterpretationBox[
   StyleBox[GridBox[{
      {"k", 
       StyleBox[GridBox[{
          {"\[Alpha]"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`k[$CellContext`\[Alpha]],
   Editable->False], 
  InterpretationBox[
   StyleBox["S",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`S[],
   Editable->False]]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[24]=",ExpressionUUID->"3a4c7ad6-948d-4974-91aa-d65d7ff4f15b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "G", ",", 
    RowBox[{"FinalFrame", "->", "G"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "@", 
   RowBox[{"k", "[", 
    RowBox[{"-", "\[Beta]"}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[25]:=",ExpressionUUID->"4b53c0f7-41db-41ab-9364-c14d3540cff2"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox[
     OverscriptBox["\[Del]", "G"], "\[Alpha]"], 
    StyleBox[
     OverscriptBox["\[Null]", "G"],
     FontSize->8], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"k", 
         StyleBox[GridBox[{
            {" "},
            {"\[Beta]"}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`k[-$CellContext`\[Beta]],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CDG[-$CellContext`\[Alpha]][
   xAct`xConf`ConformalFrame[$CellContext`G][
    $CellContext`k[-$CellContext`\[Beta]]]],
  Editable->False]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[25]=",ExpressionUUID->"b177d39f-0b07-405e-8db6-a42d1ce24066"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"\[Phi]", "[", "]"}], ",", "M"}], "]"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[26]:=",ExpressionUUID->"80404c8c-9496-49e3-a862-104edfc20d57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Phi]", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Phi][], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[26]:=",ExpressionUUID->"79143835-e3b6-4783-b111-0cbe15550f5a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "[", 
   RowBox[{
    RowBox[{"CD", "[", "\[Alpha]", "]"}], "[", 
    RowBox[{"\[Phi]", "[", "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[27]:=",ExpressionUUID->"0a05bae5-fbae-4532-852f-476d93287873"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[Del]", "\[Alpha]"], 
    SuperscriptBox["\[Del]", "\[Alpha]"], "\[Phi]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CD[-$CellContext`\[Alpha]][
   $CellContext`CD[$CellContext`\[Alpha]][
    $CellContext`\[Phi][]]],
  Editable->False]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[27]=",ExpressionUUID->"1fc7996f-85f8-4773-81bf-8f9ffefa2522"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConformalTransformation", "[", 
    RowBox[{"g", ",", "G"}], "]"}], "[", "expr", "]"}], "//", 
  "NoScalar"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[28]:=",ExpressionUUID->"1edb1f3e-69a9-4798-92c4-8d60d23c39d1"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Alpha]", "\[Beta]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Alpha]"], "S"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Alpha]][
      $CellContext`S[]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], "\[Phi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`\[Phi][]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "3"]], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Alpha]", "\[Beta]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "\[Phi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`\[Phi][]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "2"]]}]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[28]=",ExpressionUUID->"19ec4d55-d1bc-446a-9e18-106afbc00aa2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConformalWeight", "[", "\[Phi]", "]"}], "^=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"expr2", "=", 
  RowBox[{"expr", "-", 
   RowBox[{
    RowBox[{"1", "/", "6"}], "*", 
    RowBox[{"\[Phi]", "[", "]"}], 
    RowBox[{"RicciScalarCD", "[", "]"}]}]}]}]}], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[29]:=",ExpressionUUID->"d91e7fa9-09e3-4adc-b700-a76679e8a807"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"R", "[", "\[Del]", "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciScalarCD[],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox["\[Phi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Phi][],
      Editable->False]}], "6"]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[Del]", "\[Alpha]"], 
     SuperscriptBox["\[Del]", "\[Alpha]"], "\[Phi]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`\[Alpha]][
    $CellContext`CD[$CellContext`\[Alpha]][
     $CellContext`\[Phi][]]],
   Editable->False]}]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[30]=",ExpressionUUID->"cc10faf9-21ca-4a15-b089-8f0d422637a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConformalTransformation", "[", 
    RowBox[{"g", ",", "G"}], "]"}], "[", "expr2", "]"}], "//", 
  "NoScalar"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[31]:=",ExpressionUUID->"8c64d20f-98eb-47d3-88cb-7283e5b20b6d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     InterpretationBox[
      StyleBox[
       RowBox[{"R", "[", "\[Del]", "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciScalarCD[],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox["\[Phi]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[Phi][],
      Editable->False]}], 
    RowBox[{"6", " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "3"]}]]}], "+", 
  FractionBox[
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"\[Alpha]", "\[Beta]"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[$CellContext`\[Alpha], $CellContext`\[Beta]],
     Editable->False], " ", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[Del]", "\[Beta]"], 
       SubscriptBox["\[Del]", "\[Alpha]"], "\[Phi]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`\[Beta]][
      $CellContext`CD[-$CellContext`\[Alpha]][
       $CellContext`\[Phi][]]],
     Editable->False]}], 
   SuperscriptBox[
    InterpretationBox[
     StyleBox["S",
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`S[],
     Editable->False], "3"]]}]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[31]=",ExpressionUUID->"2a0ed96d-f87e-435c-84ab-cf5dac2c1752"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefVBundle", "[", 
  RowBox[{"TestBundle", ",", "M", ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{"A", ",", "B", ",", "J"}], "}"}]}], "]"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[32]:=",ExpressionUUID->"da17093c-e0ae-424e-9b14-b7f092bef031"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TestBundle",
    "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TestBundle, ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[32]:=",ExpressionUUID->"6e62bd4a-3c5b-405e-a381-e8c9b388faf5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefMetric", "[", 
  RowBox[{"1", ",", 
   RowBox[{"gInt", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[33]:=",ExpressionUUID->"42e07e49-9838-4d64-a04d-6b7fb7c5f60c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"gInt", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`gInt[-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[33]:=",ExpressionUUID->"fd45006e-20f9-47f4-9a55-9e1a08f64361"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilongInt", "[", 
    RowBox[{
     RowBox[{"-", "A"}], ",", 
     RowBox[{"-", "B"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilongInt[-$CellContext`A, -$CellContext`B], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[33]:=",ExpressionUUID->"ae4bc766-65e0-4da6-a6a4-350b701aa339"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"DetgInt", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`DetgInt[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[33]:=",ExpressionUUID->"fde43b8b-a906-4fa9-a87a-81fab2c3b1f6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"\[Mu]", ",", "A"}], "]"}], ",", "M"}], "]"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[34]:=",ExpressionUUID->"859f3562-392e-4e31-a19d-6cc2d9740662"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T", "[", 
    RowBox[{"\[Mu]", ",", "A"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`T[$CellContext`\[Mu], $CellContext`A], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[34]:=",ExpressionUUID->"b8734840-dfc8-4f39-a01e-eb4848063a0a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"T", "[", 
  RowBox[{
   RowBox[{"-", "\[Mu]"}], ",", "A"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeparateMetric", "[", "]"}], "[", "%", "]"}]}], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[35]:=",ExpressionUUID->"87274bb9-13a0-4800-8e2e-e260c685b186"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"T", 
      StyleBox[GridBox[{
         {" ", "A"},
         {"\[Mu]", " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`T[-$CellContext`\[Mu], $CellContext`A],
  Editable->False]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[35]=",ExpressionUUID->"965de3a1-53c0-401e-a9ac-dccc55fa97f6"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {"g", 
       StyleBox[GridBox[{
          {" ", " "},
          {"\[Alpha]", "\[Mu]"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`g[-$CellContext`\[Alpha], -$CellContext`\[Mu]],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"T", 
       StyleBox[GridBox[{
          {"\[Alpha]", "A"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "Rows" -> {{
              Offset[0.]}}}],
        FontSize->Rational[39, 4]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`T[$CellContext`\[Alpha], $CellContext`A],
   Editable->False]}]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[36]=",ExpressionUUID->"d66ccbe1-13f3-4939-bb7b-390269710d49"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"$Metrics", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Catch", "[", 
      RowBox[{"ConformalRules", "[", 
       RowBox[{"g", ",", "#1"}], "]"}], "]"}], "=!=", "Null"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) (Dialogue) \
In[39]:=",ExpressionUUID->"526ddc9b-82c5-43da-a56f-b0bd12a163d1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"g", ",", "G"}], "}"}]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) (Dialogue) \
Out[39]=",ExpressionUUID->"e4545805-5cca-4b1a-be46-493101e0238a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConformalRules", "[", 
  RowBox[{"g", ",", "G"}], "]"}]], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[37]:=",ExpressionUUID->"786d1acb-d8cf-4a70-b257-10e1957ec2e7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["\[Alpha]", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["\[Beta]", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[
      PatternTest[
       Pattern[$CellContext`\[Alpha], 
        Blank[]], xAct`xTensor`DownIndexQ], 
      PatternTest[
       Pattern[$CellContext`\[Beta], 
        Blank[]], xAct`xTensor`DownIndexQ]],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[GridBox[{
         {"G", 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`G[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "2"]]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {
             UnderscriptBox[
              UnderscriptBox["\[Alpha]", "_"], "_"], 
             UnderscriptBox[
              UnderscriptBox["\[Beta]", "_"], "_"]},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "Rows" -> {{
                Offset[0.]}}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`g[
      PatternTest[
       Pattern[$CellContext`\[Alpha], 
        Blank[]], xAct`xTensor`UpIndexQ], 
      PatternTest[
       Pattern[$CellContext`\[Beta], 
        Blank[]], xAct`xTensor`UpIndexQ]],
     Editable->False], "\[Rule]", 
    RowBox[{
     InterpretationBox[
      StyleBox[GridBox[{
         {"iG", 
          StyleBox[GridBox[{
             {"\[Alpha]", "\[Beta]"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "Rows" -> {{
                 Offset[0.]}}}],
           FontSize->Rational[39, 4]]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`InvG[$CellContext`\[Alpha], $CellContext`\[Beta]],
      Editable->False], " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "2"]}]}], ",", 
   RowBox[{
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detg[],
     Editable->False], "\[Rule]", 
    FractionBox[
     InterpretationBox[
      StyleBox[
       OverscriptBox["G", 
        OverscriptBox[
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]], 
         StyleBox["~",
          FontColor->RGBColor[0, 0, 0]]]],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`DetG[],
      Editable->False], 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["S",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`S[],
       Editable->False], "8"]]}]}], "}"}]], "Output",
 CellLabel->
  "(D\[EAcute]bogage) \
Out[37]=",ExpressionUUID->"806671e3-db52-4247-a795-acace65bef9e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "G"}], "]"}], "[", 
  RowBox[{"T", "[", 
   RowBox[{"\[Mu]", ",", "A"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "G"}], "]"}], "[", 
  RowBox[{"T", "[", 
   RowBox[{
    RowBox[{"-", "\[Mu]"}], ",", "A"}], "]"}], "]"}]}], "Input",
 CellLabel->
  "(D\[EAcute]bogage) \
In[38]:=",ExpressionUUID->"ee28f84e-4ea2-4fa9-b2f9-64e78e06e6b3"],

Cell[BoxData[
 TemplateBox[{
  "ConformalRules", "unknown", 
   "\"Unknown \\!\\(\\*RowBox[{\\\"\\\\\\\"conformal relation \
of\\\\\\\"\\\"}]\\) \\!\\(\\*RowBox[{\\\"g\\\"}]\\).\"", 2, 38, 1, 
   31762300986024752676, "Local", "xAct`xTensor`ConformalRules"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[38]:=",ExpressionUUID->"0eb5c204-f3f2-4d40-99b1-301e6a98c844"],

Cell[BoxData[
 TemplateBox[{
  "IndexForm", "nouse", 
   "\"Attempting to apply \
\\!\\(\\*RowBox[{\\\"\\\\\\\"IndexForm\\\\\\\"\\\"}]\\) on \
\\!\\(\\*RowBox[{\\\"\\\\\\\"<<2>>\\\\\\\"\\\"}]\\).\"", 2, 38, 2, 
   31762300986024752676, "Local", "xAct`xTensor`IndexForm"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "(D\[EAcute]bogage) Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[38]:=",ExpressionUUID->"fc788e9a-c08a-4498-99f6-16a121e04235"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "SeparateMetric"}]], "Input",
 CellLabel->"In[44]:=",ExpressionUUID->"940abf49-180a-48fd-9cd9-7e6674fd8259"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"SeparateMetric[g, b][expr, i] separates the index i \
in the expression expr using the metric g and a dummy index in basis b. The \
default for b is AIndex, introducing an abstract index. The default for g is \
the first metric of the vbundle of the index i. The default for i is the list \
of indices in expr which do not have their natural character (that specified \
at definition time for tensors, or covariant for all derivatives).\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  
                  StyleBox["\<\" SubValue Definitions\"\>", 
                   "InformationRowLabel",
                   StripOnInput->False],
                  "\"SubValues\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "SubValues", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{
                    "SeparateMetric", "[", "xAct`xTensor`Private`args1___", 
                    "]"}], "[", 
                    RowBox[{
                    "xAct`xTensor`Private`expr_Plus", ",", 
                    "xAct`xTensor`Private`args2___"}], "]"}], ":=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"SeparateMetric", "[", 
                    "xAct`xTensor`Private`args1", "]"}], "[", 
                    RowBox[{"#1", ",", "xAct`xTensor`Private`args2"}], "]"}], 
                    "&"}], ")"}], "/@", "xAct`xTensor`Private`expr"}]}]}, {
                   " "}, {
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{
                    "SeparateMetric", "[", "xAct`xTensor`Private`args1___", 
                    "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`expr_SeriesData", ",", 
                    "xAct`xTensor`Private`args2___"}], "]"}], ":=", 
                    RowBox[{"xAct`xTensor`Private`SeriesDataMap", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"SeparateMetric", "[", 
                    "xAct`xTensor`Private`args1", "]"}], "[", 
                    RowBox[{"#1", ",", "xAct`xTensor`Private`args2"}], "]"}], 
                    "&"}], ",", "xAct`xTensor`Private`expr"}], "]"}]}]}, {
                   " "}, {
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{
                    "SeparateMetric", "[", "xAct`xTensor`Private`args1___", 
                    "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`expr_Times", ",", 
                    "xAct`xTensor`Private`args2___"}], "]"}], ":=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"SeparateMetric", "[", 
                    "xAct`xTensor`Private`args1", "]"}], "[", 
                    RowBox[{"#1", ",", "xAct`xTensor`Private`args2"}], "]"}], 
                    "&"}], ")"}], "/@", "xAct`xTensor`Private`expr"}]}]}, {
                   " "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", "]"}], "[", 
                    "xAct`xTensor`Private`args__", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    RowBox[{"Automatic", ",", "AIndex"}], "]"}], "[", 
                    "xAct`xTensor`Private`args", "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{
                    "SeparateMetric", "[", "xAct`xTensor`Private`metric_", 
                    "]"}], "[", "xAct`xTensor`Private`args__", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    RowBox[{"xAct`xTensor`Private`metric", ",", "AIndex"}], 
                    "]"}], "[", "xAct`xTensor`Private`args", "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`metric_", ",", 
                    "xAct`xTensor`Private`basis_"}], "]"}], "[", 
                    RowBox[{"xAct`xTensor`Private`expr_", ",", "All"}], "]"}],
                     ":=", 
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`metric", ",", 
                    "xAct`xTensor`Private`basis"}], "]"}], "[", 
                    RowBox[{"xAct`xTensor`Private`expr", ",", 
                    RowBox[{
                    RowBox[{"IndicesOf", "[", "]"}], "[", 
                    "xAct`xTensor`Private`expr", "]"}]}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`metric_", ",", 
                    "xAct`xTensor`Private`basis_"}], "]"}], "[", 
                    RowBox[{"xAct`xTensor`Private`expr_", ",", 
                    RowBox[{"xAct`xTensor`Private`vb_", "?", "VBundleQ"}]}], 
                    "]"}], ":=", 
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`metric", ",", 
                    "xAct`xTensor`Private`basis"}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"IndicesOf", "[", "xAct`xTensor`Private`vb", 
                    "]"}], "[", "xAct`xTensor`Private`expr", "]"}], 
                    "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`metric_", ",", 
                    "xAct`xTensor`Private`basis_"}], "]"}], "[", 
                    RowBox[{"xAct`xTensor`Private`expr_", ",", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`basis2_Symbol", "?", "BasisQ"}]}], 
                    "]"}], ":=", 
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`metric", ",", 
                    "xAct`xTensor`Private`basis"}], "]"}], "[", 
                    RowBox[{"xAct`xTensor`Private`expr", ",", 
                    RowBox[{
                    
                    RowBox[{"IndicesOf", "[", "xAct`xTensor`Private`basis2", 
                    "]"}], "[", "xAct`xTensor`Private`expr", "]"}]}], 
                    "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`metric_", ",", 
                    "xAct`xTensor`Private`basis_"}], "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`expr_", ",", 
                    "xAct`xTensor`Private`f_IndicesOf"}], "]"}], ":=", 
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`metric", ",", 
                    "xAct`xTensor`Private`basis"}], "]"}], "[", 
                    RowBox[{"xAct`xTensor`Private`expr", ",", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`f", "[", 
                    "xAct`xTensor`Private`expr", "]"}]}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`metric_", ",", 
                    "xAct`xTensor`Private`basis_"}], "]"}], "[", 
                    "xAct`xTensor`Private`expr_", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`metric", ",", 
                    "xAct`xTensor`Private`basis"}], "]"}], "[", 
                    RowBox[{"xAct`xTensor`Private`expr", ",", "Automatic"}], 
                    "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`metric_", ",", 
                    "xAct`xTensor`Private`basis_"}], "]"}], "[", 
                    RowBox[{"xAct`xTensor`Private`expr_", ",", "Automatic"}], 
                    "]"}], ":=", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"xAct`xTensor`Private`tensors", "=", 
                    RowBox[{"FindAllOfType", "[", 
                    RowBox[{"xAct`xTensor`Private`expr", ",", "Tensor"}], 
                    "]"}]}], ",", 
                    RowBox[{"xAct`xTensor`Private`covds", "=", 
                    RowBox[{"FindAllOfType", "[", 
                    RowBox[{"xAct`xTensor`Private`expr", ",", "CovD"}], 
                    "]"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{"xAct`xTensor`Private`metric", ",", 
                    "xAct`xTensor`Private`basis"}], "]"}], "[", 
                    RowBox[{"xAct`xTensor`Private`expr", ",", 
                    RowBox[{"Flatten", "[", 
                    RowBox[{"IndexList", "@@", 
                    RowBox[{"xAct`xTensor`Private`movedindices", "/@", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"xAct`xTensor`Private`tensors", ",", 
                    "xAct`xTensor`Private`covds"}], "]"}]}]}], "]"}]}], 
                    "]"}]}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`metric_", ",", 
                    "xAct`xTensor`Private`basis_"}], "]"}], "[", 
                    RowBox[{
                    "xAct`xTensor`Private`expr_", ",", 
                    "xAct`xTensor`Private`list_IndexList"}], "]"}], ":=", 
                    RowBox[{"Fold", "[", 
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{"xAct`xTensor`Private`metric", ",", 
                    "xAct`xTensor`Private`basis"}], "]"}], ",", 
                    "xAct`xTensor`Private`expr", ",", 
                    RowBox[{"DeleteCases", "[", 
                    RowBox[{"xAct`xTensor`Private`list", ",", 
                    RowBox[{"_LI", "|", 
                    RowBox[{"-", "_LI"}]}]}], "]"}]}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", "___", "]"}], "[", "]"}], 
                    ":=", 
                    RowBox[{"Throw", "[", "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    RowBox[{"_", ",", "_", ",", "__"}], "]"}], "[", "__", 
                    "]"}], ":=", 
                    RowBox[{"Throw", "[", "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", "___", "]"}], "[", 
                    RowBox[{"_", ",", "_", ",", "__"}], "]"}], ":=", 
                    RowBox[{"Throw", "[", "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"SeparateMetric", "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`metric_", ",", 
                    "xAct`xTensor`Private`basis_"}], "]"}], "[", 
                    RowBox[{"xAct`xTensor`Private`expr_", ",", 
                    RowBox[{"xAct`xTensor`Private`index_", "?", "GIndexQ"}]}],
                     "]"}], ":=", 
                    RowBox[{
                    RowBox[{"xAct`xTensor`Private`SeparateMetric1", "[", 
                    
                    RowBox[{
                    "xAct`xTensor`Private`basis", ",", 
                    "xAct`xTensor`Private`metric", ",", 
                    
                    RowBox[{"xAct`xTensor`Private`FirstMetricOfVBundle", "[", 
                    
                    
                    RowBox[{"VBundleOfIndex", "[", 
                    "xAct`xTensor`Private`index", "]"}], "]"}]}], "]"}], "[", 
                    
                    
                    RowBox[{
                    "xAct`xTensor`Private`expr", ",", 
                    "xAct`xTensor`Private`index"}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`SeparateMetric\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"SeparateMetric[g, b][expr, i] separates the index i \
in the expression expr using the metric g and a dummy index in basis b. The \
default for b is AIndex, introducing an abstract index. The default for g is \
the first metric of the vbundle of the index i. The default for i is the list \
of indices in expr which do not have their natural character (that specified \
at definition time for tensors, or covariant for all derivatives).\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "SeparateMetric[g, b][expr, i] separates the index i in the expression \
expr using the metric g and a dummy index in basis b. The default for b is \
AIndex, introducing an abstract index. The default for g is the first metric \
of the vbundle of the index i. The default for i is the list of indices in \
expr which do not have their natural character (that specified at definition \
time for tensors, or covariant for all derivatives).", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> 
    Information`InformationValueForm[
     SubValues, xAct`xTensor`SeparateMetric, {xAct`xTensor`SeparateMetric[
         Pattern[xAct`xTensor`Private`args1, 
          BlankNullSequence[]]][
         Pattern[xAct`xTensor`Private`expr, 
          Blank[Plus]], 
         Pattern[xAct`xTensor`Private`args2, 
          BlankNullSequence[]]] :> 
       Map[xAct`xTensor`SeparateMetric[
         xAct`xTensor`Private`args1][#, xAct`xTensor`Private`args2]& , 
         xAct`xTensor`Private`expr], xAct`xTensor`SeparateMetric[
         Pattern[xAct`xTensor`Private`args1, 
          BlankNullSequence[]]][
         Pattern[xAct`xTensor`Private`expr, 
          Blank[SeriesData]], 
         Pattern[xAct`xTensor`Private`args2, 
          BlankNullSequence[]]] :> 
       xAct`xTensor`Private`SeriesDataMap[
        xAct`xTensor`SeparateMetric[
         xAct`xTensor`Private`args1][#, xAct`xTensor`Private`args2]& , 
         xAct`xTensor`Private`expr], xAct`xTensor`SeparateMetric[
         Pattern[xAct`xTensor`Private`args1, 
          BlankNullSequence[]]][
         Pattern[xAct`xTensor`Private`expr, 
          Blank[Times]], 
         Pattern[xAct`xTensor`Private`args2, 
          BlankNullSequence[]]] :> 
       Map[xAct`xTensor`SeparateMetric[
         xAct`xTensor`Private`args1][#, xAct`xTensor`Private`args2]& , 
         xAct`xTensor`Private`expr], xAct`xTensor`SeparateMetric[][
         Pattern[xAct`xTensor`Private`args, 
          BlankSequence[]]] :> 
       xAct`xTensor`SeparateMetric[Automatic, xAct`xTensor`AIndex][
        xAct`xTensor`Private`args], xAct`xTensor`SeparateMetric[
         Pattern[xAct`xTensor`Private`metric, 
          Blank[]]][
         Pattern[xAct`xTensor`Private`args, 
          BlankSequence[]]] :> 
       xAct`xTensor`SeparateMetric[
        xAct`xTensor`Private`metric, xAct`xTensor`AIndex][
        xAct`xTensor`Private`args], xAct`xTensor`SeparateMetric[
         Pattern[xAct`xTensor`Private`metric, 
          Blank[]], 
         Pattern[xAct`xTensor`Private`basis, 
          Blank[]]][
         Pattern[xAct`xTensor`Private`expr, 
          Blank[]], All] :> 
       xAct`xTensor`SeparateMetric[
        xAct`xTensor`Private`metric, xAct`xTensor`Private`basis][
        xAct`xTensor`Private`expr, 
         xAct`xTensor`IndicesOf[][xAct`xTensor`Private`expr]], 
       xAct`xTensor`SeparateMetric[
         Pattern[xAct`xTensor`Private`metric, 
          Blank[]], 
         Pattern[xAct`xTensor`Private`basis, 
          Blank[]]][
         Pattern[xAct`xTensor`Private`expr, 
          Blank[]], 
         PatternTest[
          Pattern[xAct`xTensor`Private`vb, 
           Blank[]], xAct`xTensor`VBundleQ]] :> 
       xAct`xTensor`SeparateMetric[
        xAct`xTensor`Private`metric, xAct`xTensor`Private`basis][
         xAct`xTensor`IndicesOf[xAct`xTensor`Private`vb][
         xAct`xTensor`Private`expr]], xAct`xTensor`SeparateMetric[
         Pattern[xAct`xTensor`Private`metric, 
          Blank[]], 
         Pattern[xAct`xTensor`Private`basis, 
          Blank[]]][
         Pattern[xAct`xTensor`Private`expr, 
          Blank[]], 
         PatternTest[
          Pattern[xAct`xTensor`Private`basis2, 
           Blank[Symbol]], xAct`xTensor`BasisQ]] :> 
       xAct`xTensor`SeparateMetric[
        xAct`xTensor`Private`metric, xAct`xTensor`Private`basis][
        xAct`xTensor`Private`expr, 
         xAct`xTensor`IndicesOf[xAct`xTensor`Private`basis2][
         xAct`xTensor`Private`expr]], xAct`xTensor`SeparateMetric[
         Pattern[xAct`xTensor`Private`metric, 
          Blank[]], 
         Pattern[xAct`xTensor`Private`basis, 
          Blank[]]][
         Pattern[xAct`xTensor`Private`expr, 
          Blank[]], 
         Pattern[xAct`xTensor`Private`f, 
          Blank[xAct`xTensor`IndicesOf]]] :> 
       xAct`xTensor`SeparateMetric[
        xAct`xTensor`Private`metric, xAct`xTensor`Private`basis][
        xAct`xTensor`Private`expr, 
         xAct`xTensor`Private`f[xAct`xTensor`Private`expr]], 
       xAct`xTensor`SeparateMetric[
         Pattern[xAct`xTensor`Private`metric, 
          Blank[]], 
         Pattern[xAct`xTensor`Private`basis, 
          Blank[]]][
         Pattern[xAct`xTensor`Private`expr, 
          Blank[]]] :> 
       xAct`xTensor`SeparateMetric[
        xAct`xTensor`Private`metric, xAct`xTensor`Private`basis][
        xAct`xTensor`Private`expr, Automatic], xAct`xTensor`SeparateMetric[
         Pattern[xAct`xTensor`Private`metric, 
          Blank[]], 
         Pattern[xAct`xTensor`Private`basis, 
          Blank[]]][
         Pattern[xAct`xTensor`Private`expr, 
          Blank[]], Automatic] :> 
       With[{xAct`xTensor`Private`tensors = 
          xAct`xTensor`FindAllOfType[
           xAct`xTensor`Private`expr, xAct`xTensor`Tensor], 
          xAct`xTensor`Private`covds = 
          xAct`xTensor`FindAllOfType[
           xAct`xTensor`Private`expr, xAct`xTensor`CovD]}, 
         xAct`xTensor`SeparateMetric[
         xAct`xTensor`Private`metric, xAct`xTensor`Private`basis][
         xAct`xTensor`Private`expr, 
          Flatten[
           Apply[xAct`xTensor`IndexList, 
            Map[xAct`xTensor`Private`movedindices, 
             Join[
             xAct`xTensor`Private`tensors, xAct`xTensor`Private`covds]]]]]], 
       xAct`xTensor`SeparateMetric[
         Pattern[xAct`xTensor`Private`metric, 
          Blank[]], 
         Pattern[xAct`xTensor`Private`basis, 
          Blank[]]][
         Pattern[xAct`xTensor`Private`expr, 
          Blank[]], 
         Pattern[xAct`xTensor`Private`list, 
          Blank[xAct`xTensor`IndexList]]] :> Fold[
         xAct`xTensor`SeparateMetric[
         xAct`xTensor`Private`metric, xAct`xTensor`Private`basis], 
         xAct`xTensor`Private`expr, 
         DeleteCases[xAct`xTensor`Private`list, 
          Alternatives[
           Blank[xAct`xTensor`LI], -Blank[xAct`xTensor`LI]]]], 
       xAct`xTensor`SeparateMetric[
         BlankNullSequence[]][] :> Throw[], xAct`xTensor`SeparateMetric[
         Blank[], 
         Blank[], 
         BlankSequence[]][
         BlankSequence[]] :> Throw[], xAct`xTensor`SeparateMetric[
         BlankNullSequence[]][
         Blank[], 
         Blank[], 
         BlankSequence[]] :> Throw[], xAct`xTensor`SeparateMetric[
         Pattern[xAct`xTensor`Private`metric, 
          Blank[]], 
         Pattern[xAct`xTensor`Private`basis, 
          Blank[]]][
         Pattern[xAct`xTensor`Private`expr, 
          Blank[]], 
         PatternTest[
          Pattern[xAct`xTensor`Private`index, 
           Blank[]], xAct`xTensor`GIndexQ]] :> 
       xAct`xTensor`Private`SeparateMetric1[
        xAct`xTensor`Private`basis, xAct`xTensor`Private`metric, 
         xAct`xTensor`Private`FirstMetricOfVBundle[
          xAct`xTensor`VBundleOfIndex[xAct`xTensor`Private`index]]][
        xAct`xTensor`Private`expr, xAct`xTensor`Private`index]}], 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`SeparateMetric"|>, False]]], "Output",
 CellLabel->
  "Out[44]=",ExpressionUUID->"f15f78c0-f033-41c3-8125-4f262df54882"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<xAct`xCoBa`\>\"", "]"}]], "Input",
 CellLabel->"In[45]:=",ExpressionUUID->"d7eadf6a-ac4b-4a10-b188-c4b3e51bcc30"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[45]:=",ExpressionUUID->"5503aa65-f0d3-4cc1-a452-32147f98928a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCoba`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.8.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xCoba`  version ", "0.8.6", ", ", {2021, 2, 28}],
  
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[45]:=",ExpressionUUID->"ad993379-6747-4725-adf6-178e67836264"],

Cell[BoxData["\<\"CopyRight (C) 2005-2021, David Yllanes and Jose M. \
Martin-Garcia, under the General Public License.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[45]:=",ExpressionUUID->"41a777b4-ee88-47eb-82f9-85e55790e6a0"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[45]:=",ExpressionUUID->"5c61206e-ecca-4d8d-9782-6f980bd1769e"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[45]:=",ExpressionUUID->"92289a88-6b24-4069-a061-a9012c875a70"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[45]:=",ExpressionUUID->"0602f271-3251-43ef-b62a-d906253be2ed"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Needs", "nocont", 
   "\"Context \\!\\(\\*RowBox[{\\\"\\\\\\\"xAct`xCoBa`\\\\\\\"\\\"}]\\) was \
not created when Needs was evaluated.\"", 2, 45, 9, 31762299904679089286, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[45]:=",ExpressionUUID->"51a5684c-c80f-44cf-9348-d88055e77092"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefBasis", "[", 
  RowBox[{"Ba", ",", "TangentM", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[46]:=",ExpressionUUID->"761cf349-057f-4587-9793-47427d650b39"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "Ba", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`Ba, ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[46]:=",ExpressionUUID->"5047d034-eca9-467c-a878-be7a221ea29b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDBa", "[", 
    RowBox[{"-", "\[Alpha]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDBa[-$CellContext`\[Alpha]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[46]:=",ExpressionUUID->"b45ca97e-df8d-4e2b-8343-c50b9439c3f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionPDBa", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionPDBa[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[46]:=",ExpressionUUID->"f057b4d0-a36c-4333-a400-054e8ca03fcc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDBa", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDBa[$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda]], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[46]:=",ExpressionUUID->"5ddf2ee2-d1dd-4d1a-9300-b470108773fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDBa", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}], ",", "\[Lambda]1"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDBa[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda], $CellContext`\[Lambda]1], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[46]:=",ExpressionUUID->"813d550e-ab79-44eb-861c-b6ee1079b1ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDBa", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDBa[-$CellContext`\[Alpha], -$CellContext`\[Beta]], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[46]:=",ExpressionUUID->"3d7daf94-e919-46a0-8e4c-2c1b1a4c3393"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpBa", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Lambda]", ",", "\[Lambda]1"}],
     "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpBa[$CellContext`\[Alpha], $CellContext`\[Beta], \
$CellContext`\[Lambda], $CellContext`\[Lambda]1], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[46]:=",ExpressionUUID->"4107e155-e8e2-4f3b-8668-6cdf9b15d132"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownBa", "[", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], ",", 
     RowBox[{"-", "\[Beta]"}], ",", 
     RowBox[{"-", "\[Lambda]"}], ",", 
     RowBox[{"-", "\[Lambda]1"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownBa[-$CellContext`\[Alpha], -$CellContext`\[Beta], \
-$CellContext`\[Lambda], -$CellContext`\[Lambda]1], ". ", ""],
  Editable->False]], "Print",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[46]:=",ExpressionUUID->"eff73ae0-a3bc-4f00-a929-f2fdb9cc2a7b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Basis"}]], "Input",
 CellLabel->"In[47]:=",ExpressionUUID->"d1f485e4-741e-4233-ad89-b94a7e2e8edb"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Basis represents both the type and the tensor head \
for a basis vector/covector field.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  
                  StyleBox["\<\" UpValue Definitions\"\>", 
                   "InformationRowLabel",
                   StripOnInput->False],
                  "\"UpValues\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "UpValues", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Dagger", "[", "Basis", "]"}], AutoSpacing -> 
                    False, ShowAutoStyles -> False], 
                    xAct`xTensor`Dagger[xAct`xTensor`Basis], Editable -> 
                    False], "^=", "Basis"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"DependenciesOfTensor", "[", "Basis", "]"}], 
                    "^:=", 
                    RowBox[{"{", "}"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"MasterOf", "[", "Basis", "]"}], "^=", 
                    "Symbol"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"PrintAs", "[", "Basis", "]"}], "^=", 
                    "\"e\""}]}, {" "}, {
                    RowBox[{
                    RowBox[{"SlotsOfTensor", "[", "Basis", "]"}], "^:=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "All"}], ",", "All"}], "}"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"xTensorQ", "[", "Basis", "]"}], "^=", 
                    "True"}]}, {" "}, {
                    RowBox[{
                    RowBox[{"SymmetryGroupOfTensor", "[", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xCoba`Private`a\+_\)", 
                    "\!\(xAct`xCoba`Private`b\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[
                    Pattern[xAct`xCoba`Private`a, 
                    Blank[]], 
                    Pattern[xAct`xCoba`Private`b, 
                    Blank[]]], Editable -> False], "]"}], "^:=", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"xAct`xCoba`Private`metric", "=", 
                    
                    RowBox[{"xAct`xTensor`Private`FirstMetricOfVBundle", "[", 
                    
                    RowBox[{
                    
                    RowBox[{"VBundleOfIndex", "[", "xAct`xCoba`Private`a", 
                    "]"}], ",", "False"}], "]"}]}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"xAct`xCoba`Private`metric", "===", "Null"}], ",", 
                    RowBox[{"StrongGenSet", "[", 
                    RowBox[{
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", 
                    
                    RowBox[{"SymmetryGroupOfTensor", "[", 
                    "xAct`xCoba`Private`metric", "]"}]}], "]"}]}], "]"}]}]}, {
                   " "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"xAct`xCoba`Private`f_Symbol", "/;", 
                    RowBox[{"xAct`xCoba`Private`f", "===", "Times"}]}], ")"}],
                     "[", 
                    RowBox[{"xAct`xCoba`Private`expr1___", ",", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{" ", 
                    "\!\(\*StyleBox[\"\!\(xAct`xCoba`Private`b\+_\)\",\
FontColor->RGBColor[1., 0., 0.]]\)"}, {
                    "\!\(\*StyleBox[\"\!\(xAct`xCoba`Private`a\+_\)\",\
FontColor->RGBColor[1., 0., 0.]]\)", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[{-Pattern[xAct`xCoba`Private`a, 
                    Blank[Symbol]], -Pattern[xAct`xCoba`Private`basis, 
                    Blank[]]}, {
                    Pattern[xAct`xCoba`Private`b, 
                    Blank[Symbol]], 
                    Pattern[xAct`xCoba`Private`basis, 
                    Blank[]]}], Editable -> False], ",", 
                    "xAct`xCoba`Private`expr2___"}], "]"}], "^:=", 
                    RowBox[{
                    RowBox[{"ReplaceIndex", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xCoba`Private`expr1", " ", 
                    "xAct`xCoba`Private`expr2"}], ",", 
                    RowBox[{
                    RowBox[{"-", "xAct`xCoba`Private`b"}], "\[Rule]", 
                    RowBox[{"-", "xAct`xCoba`Private`a"}]}]}], "]"}], "/;", 
                    RowBox[{"IsIndexOf", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xCoba`Private`expr1", " ", 
                    "xAct`xCoba`Private`expr2"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "xAct`xCoba`Private`b"}], ",", 
                    RowBox[{"-", "xAct`xCoba`Private`basis"}]}], "}"}], ",", 
                    "Basis"}], "]"}]}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"xAct`xCoba`Private`f_Symbol", "/;", 
                    RowBox[{"xAct`xCoba`Private`f", "===", "Times"}]}], ")"}],
                     "[", 
                    RowBox[{"xAct`xCoba`Private`expr1___", ",", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{" ", 
                    "\!\(\*StyleBox[\"\!\(xAct`xCoba`Private`b\+_\)\",\
FontColor->RGBColor[1., 0., 0.]]\)"}, {
                    "\!\(\*StyleBox[\"\!\(xAct`xCoba`Private`a\+_\)\",\
FontColor->RGBColor[1., 0., 0.]]\)", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[{-Pattern[xAct`xCoba`Private`a, 
                    Blank[Symbol]], -Pattern[xAct`xCoba`Private`basis, 
                    Blank[]]}, {
                    Pattern[xAct`xCoba`Private`b, 
                    Blank[Symbol]], 
                    Pattern[xAct`xCoba`Private`basis, 
                    Blank[]]}], Editable -> False], ",", 
                    "xAct`xCoba`Private`expr2___"}], "]"}], "^:=", 
                    RowBox[{
                    RowBox[{"ReplaceIndex", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xCoba`Private`expr1", " ", 
                    "xAct`xCoba`Private`expr2"}], ",", 
                    
                    RowBox[{"xAct`xCoba`Private`a", "\[Rule]", 
                    "xAct`xCoba`Private`b"}]}], "]"}], "/;", 
                    RowBox[{"IsIndexOf", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xCoba`Private`expr1", " ", 
                    "xAct`xCoba`Private`expr2"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xCoba`Private`a", ",", 
                    "xAct`xCoba`Private`basis"}], "}"}], ",", "Basis"}], 
                    "]"}]}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"HoldPattern", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"xAct`xCoba`Private`covd_", "?", "CovDQ"}], "[", 
                    "xAct`xCoba`Private`a_", "]"}], "[", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{" ", "\!\(xAct`xCoba`Private`b\+_\)"}, {
                    "\!\(\*StyleBox[\"\!\(xAct`xCoba`Private`c\+_\)\",\
FontColor->RGBColor[1., 0., 0.]]\)", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[{
                    Pattern[xAct`xCoba`Private`c, 
                    Blank[]], -PatternTest[
                    Pattern[xAct`xCoba`Private`basis, 
                    Blank[]], xAct`xTensor`BasisQ]}, 
                    Pattern[xAct`xCoba`Private`b, 
                    Blank[Symbol]]], Editable -> False], "]"}], "]"}], "^:=", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"xAct`xCoba`Private`CommonDependencies", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xCoba`Private`covd", "[", 
                    "xAct`xCoba`Private`a", "]"}], ",", 
                    RowBox[{"{", "xAct`xCoba`Private`basis", "}"}]}], "]"}], 
                    "===", 
                    RowBox[{"{", "}"}]}], ",", "0", ",", 
                    RowBox[{
                    RowBox[{"Christoffel", "[", 
                    RowBox[{"xAct`xCoba`Private`covd", ",", 
                    
                    RowBox[{"PDOfBasis", "[", "xAct`xCoba`Private`basis", 
                    "]"}]}], "]"}], "[", 
                    
                    RowBox[{"xAct`xCoba`Private`b", ",", 
                    "xAct`xCoba`Private`a", ",", 
                    RowBox[{"{", 
                    RowBox[{"xAct`xCoba`Private`c", ",", 
                    RowBox[{"-", "xAct`xCoba`Private`basis"}]}], "}"}]}], 
                    "]"}]}], "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"HoldPattern", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"xAct`xCoba`Private`covd_", "?", "CovDQ"}], "[", 
                    "xAct`xCoba`Private`a_", "]"}], "[", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{" ", 
                    "\!\(\*StyleBox[\"\!\(xAct`xCoba`Private`c\+_\)\",\
FontColor->RGBColor[1., 0., 0.]]\)"}, {"\!\(xAct`xCoba`Private`b\+_\)", " "}},
                     RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[-Pattern[xAct`xCoba`Private`b, 
                    Blank[Symbol]], {
                    Pattern[xAct`xCoba`Private`c, 
                    Blank[]], 
                    PatternTest[
                    Pattern[xAct`xCoba`Private`basis, 
                    Blank[]], xAct`xTensor`BasisQ]}], Editable -> False], 
                    "]"}], "]"}], "^:=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"xAct`xCoba`Private`CommonDependencies", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xCoba`Private`covd", "[", 
                    "xAct`xCoba`Private`a", "]"}], ",", 
                    RowBox[{"{", "xAct`xCoba`Private`basis", "}"}]}], "]"}], 
                    "===", 
                    RowBox[{"{", "}"}]}], ",", "0", ",", 
                    RowBox[{"-", 
                    RowBox[{
                    RowBox[{"Christoffel", "[", 
                    RowBox[{"xAct`xCoba`Private`covd", ",", 
                    
                    RowBox[{"PDOfBasis", "[", "xAct`xCoba`Private`basis", 
                    "]"}]}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xCoba`Private`c", ",", 
                    "xAct`xCoba`Private`basis"}], "}"}], ",", 
                    "xAct`xCoba`Private`a", ",", 
                    RowBox[{"-", "xAct`xCoba`Private`b"}]}], "]"}]}]}], 
                    "]"}]}]}, {" "}, {
                    RowBox[{
                    RowBox[{"HoldPattern", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"xAct`xCoba`Private`covd_", "?", "CovDQ"}], "[", 
                    "xAct`xCoba`Private`a_", "]"}], "[", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xCoba`Private`c\+_\)", 
                    "\!\(xAct`xCoba`Private`b\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[
                    Pattern[xAct`xCoba`Private`c, {
                    Blank[], -PatternTest[
                    Pattern[xAct`xCoba`Private`basisc, 
                    Blank[]], xAct`xTensor`BasisQ]}], 
                    Pattern[xAct`xCoba`Private`b, {
                    Blank[], 
                    PatternTest[
                    Pattern[xAct`xCoba`Private`basisb, 
                    Blank[]], xAct`xTensor`BasisQ]}]], Editable -> False], 
                    "]"}], "]"}], "^:=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"xAct`xCoba`Private`CommonDependencies", "[", 
                    RowBox[{
                    
                    RowBox[{"xAct`xCoba`Private`covd", "[", 
                    "xAct`xCoba`Private`a", "]"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"xAct`xCoba`Private`basisc", ",", 
                    "xAct`xCoba`Private`basisb"}], "}"}]}], "]"}], "===", 
                    RowBox[{"{", "}"}]}], ",", "0", ",", 
                    RowBox[{
                    RowBox[{"Christoffel", "[", 
                    RowBox[{
                    
                    RowBox[{"PDOfBasis", "[", "xAct`xCoba`Private`basisb", 
                    "]"}], ",", 
                    
                    RowBox[{"PDOfBasis", "[", "xAct`xCoba`Private`basisc", 
                    "]"}]}], "]"}], "[", 
                    
                    RowBox[{"xAct`xCoba`Private`b", ",", 
                    "xAct`xCoba`Private`a", ",", "xAct`xCoba`Private`c"}], 
                    "]"}]}], "]"}]}]}, {" "}, {
                    RowBox[{"Basis", "/:", 
                    RowBox[{"ToCTensor", "[", 
                    RowBox[{"Basis", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"CBasis", "[", 
                    
                    RowBox[{"xAct`xCoba`Private`basis_", ",", 
                    "xAct`xCoba`Private`matrix_"}], "]"}]}], ",", 
                    "xAct`xCoba`Private`basis_"}], "}"}], ",", "0"}], "]"}], 
                    ":=", 
                    RowBox[{"CTensor", "[", 
                    RowBox[{
                    
                    TemplateBox[{"xAct`xCoba`Private`matrix"}, "Inverse", 
                    SyntaxForm -> SuperscriptBox], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"CBasis", "[", 
                    
                    RowBox[{"xAct`xCoba`Private`basis", ",", 
                    "xAct`xCoba`Private`matrix"}], "]"}]}], ",", 
                    "xAct`xCoba`Private`basis"}], "}"}], ",", "0"}], 
                    "]"}]}]}, {" "}, {
                    RowBox[{"Basis", "/:", 
                    RowBox[{"ToCTensor", "[", 
                    RowBox[{"Basis", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "xAct`xCoba`Private`basis_"}], ",", 
                    RowBox[{"CBasis", "[", 
                    
                    RowBox[{"xAct`xCoba`Private`basis_", ",", 
                    "xAct`xCoba`Private`matrix_"}], "]"}]}], "}"}], ",", 
                    "0"}], "]"}], ":=", 
                    RowBox[{"CTensor", "[", 
                    RowBox[{"xAct`xCoba`Private`matrix", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "xAct`xCoba`Private`basis"}], ",", 
                    RowBox[{"CBasis", "[", 
                    
                    RowBox[{"xAct`xCoba`Private`basis", ",", 
                    "xAct`xCoba`Private`matrix"}], "]"}]}], "}"}], ",", "0"}],
                     "]"}]}]}, {" "}, {
                    RowBox[{"Basis", "/:", 
                    RowBox[{"ToCTensor", "[", 
                    RowBox[{"Basis", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"CBasis", "[", 
                    
                    RowBox[{"xAct`xCoba`Private`basis_", ",", 
                    "xAct`xCoba`Private`matrix1_"}], "]"}]}], ",", 
                    RowBox[{"CBasis", "[", 
                    
                    RowBox[{"xAct`xCoba`Private`basis_", ",", 
                    "xAct`xCoba`Private`matrix2_"}], "]"}]}], "}"}], ",", 
                    "0"}], "]"}], ":=", 
                    RowBox[{"CTensor", "[", 
                    RowBox[{
                    RowBox[{
                    
                    TemplateBox[{"xAct`xCoba`Private`matrix1"}, "Inverse", 
                    SyntaxForm -> SuperscriptBox], ".", 
                    "xAct`xCoba`Private`matrix2"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"CBasis", "[", 
                    
                    RowBox[{"xAct`xCoba`Private`basis", ",", 
                    "xAct`xCoba`Private`matrix1"}], "]"}]}], ",", 
                    RowBox[{"CBasis", "[", 
                    
                    RowBox[{"xAct`xCoba`Private`basis", ",", 
                    "xAct`xCoba`Private`matrix2"}], "]"}]}], "}"}], ",", 
                    "0"}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]},
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  
                  StyleBox["\<\" DownValue Definitions\"\>", 
                   "InformationRowLabel",
                   StripOnInput->False],
                  "\"DownValues\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "DownValues", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{" ", "\!\(xAct`xCoba`Private`b\+_\)"}, {
                    "\!\(xAct`xCoba`Private`a\+_\)", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[-Pattern[xAct`xCoba`Private`a, 
                    Blank[Symbol]], 
                    Pattern[xAct`xCoba`Private`b, 
                    Blank[Symbol]]], Editable -> False], ":=", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Delta]", 
                    StyleBox[
                    
                    GridBox[{{" ", "xAct`xCoba`Private`b"}, {
                    "xAct`xCoba`Private`a", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    
                    xAct`xTensor`delta[-xAct`xCoba`Private`a, 
                    xAct`xCoba`Private`b], Editable -> False]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xCoba`Private`a\+_\)", 
                    "\!\(\!\(xAct`xCoba`Private`b\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[
                    Pattern[xAct`xCoba`Private`a, 
                    Blank[Symbol]], 
                    PatternTest[
                    Pattern[xAct`xCoba`Private`b, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    
                    RowBox[{
                    "xAct`xTensor`Private`SymmetryOfIndex", "[", 
                    "xAct`xCoba`Private`a", "]"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xCoba`Private`b", 
                    "xAct`xCoba`Private`a"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[
                    xAct`xCoba`Private`b, xAct`xCoba`Private`a], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xCoba`Private`a\+_\)", 
                    "\!\(\!\(xAct`xCoba`Private`b\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[
                    Pattern[xAct`xCoba`Private`a, {
                    Blank[], 
                    PatternTest[
                    Blank[], xAct`xTensor`BasisQ]}], 
                    PatternTest[
                    Pattern[xAct`xCoba`Private`b, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    
                    RowBox[{
                    "xAct`xTensor`Private`SymmetryOfIndex", "[", 
                    "xAct`xCoba`Private`a", "]"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xCoba`Private`b", 
                    "xAct`xCoba`Private`a"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[
                    xAct`xCoba`Private`b, xAct`xCoba`Private`a], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xCoba`Private`a\+_\)", 
                    "\!\(\!\(xAct`xCoba`Private`b\+_\)\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[
                    Pattern[xAct`xCoba`Private`a, 
                    PatternTest[
                    Blank[], xAct`xTensor`BasisQ][
                    Blank[]]], 
                    PatternTest[
                    Pattern[xAct`xCoba`Private`b, 
                    Blank[]], xAct`xTensor`DownIndexQ]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    
                    RowBox[{
                    "xAct`xTensor`Private`SymmetryOfIndex", "[", 
                    "xAct`xCoba`Private`a", "]"}], " ", 
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{"xAct`xCoba`Private`b", 
                    "xAct`xCoba`Private`a"}, {" ", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[
                    xAct`xCoba`Private`b, xAct`xCoba`Private`a], Editable -> 
                    False]}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xCoba`Private`a\+_\)", 
                    "\!\(xAct`xCoba`Private`b\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[
                    Pattern[xAct`xCoba`Private`a, 
                    Alternatives[
                    Blank[Symbol], {
                    Blank[], 
                    PatternTest[
                    Blank[], xAct`xTensor`BasisQ]}]], 
                    Pattern[xAct`xCoba`Private`b, 
                    Alternatives[
                    Blank[Symbol], {
                    Blank[], 
                    PatternTest[
                    Blank[], xAct`xTensor`BasisQ]}]]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    
                    RowBox[{
                    "xAct`xTensor`Private`FirstMetricOfVBundle", "[", 
                    RowBox[{
                    
                    RowBox[{"VBundleOfIndex", "[", "xAct`xCoba`Private`a", 
                    "]"}], ",", "True"}], "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xCoba`Private`a", ",", "xAct`xCoba`Private`b"}], 
                    "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xCoba`Private`a\+_\)", 
                    "\!\(xAct`xCoba`Private`b\+_\)"}, {" ", " "}}, 
                    RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[
                    Pattern[xAct`xCoba`Private`a, 
                    Alternatives[-Blank[Symbol], {
                    Blank[], -PatternTest[
                    Blank[], xAct`xTensor`BasisQ]}]], 
                    Pattern[xAct`xCoba`Private`b, 
                    Alternatives[-Blank[Symbol], {
                    Blank[], -PatternTest[
                    Blank[], xAct`xTensor`BasisQ]}]]], Editable -> False], 
                    ":=", 
                    RowBox[{
                    
                    RowBox[{
                    "xAct`xTensor`Private`FirstMetricOfVBundle", "[", 
                    RowBox[{
                    
                    RowBox[{"VBundleOfIndex", "[", "xAct`xCoba`Private`a", 
                    "]"}], ",", "True"}], "]"}], "[", 
                    
                    RowBox[{
                    "xAct`xCoba`Private`a", ",", "xAct`xCoba`Private`b"}], 
                    "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{" ", 
                    "\!\(\*StyleBox[\"\!\(xAct`xCoba`Private`j\+_\)\",\
FontColor->RGBColor[1., 0., 0.]]\)"}, {
                    "\!\(\*StyleBox[\"\!\(xAct`xCoba`Private`i\+_\)\",\
FontColor->RGBColor[1., 0., 0.]]\)", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[{
                    Pattern[xAct`xCoba`Private`i, 
                    Blank[Integer]], -Pattern[xAct`xCoba`Private`basis, 
                    Blank[]]}, {
                    Pattern[xAct`xCoba`Private`j, 
                    Blank[Integer]], 
                    Pattern[xAct`xCoba`Private`basis, 
                    Blank[]]}], Editable -> False], ":=", 
                    TemplateBox[{
                    
                    RowBox[{
                    "xAct`xCoba`Private`i", ",", "xAct`xCoba`Private`j"}]}, 
                    "KroneckerDeltaSeq"]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{" ", 
                    "\!\(\*StyleBox[\"\!\(xAct`xCoba`Private`a\+_\)\",\
FontColor->RGBColor[1., 0., 0.]]\)"}, {
                    "\!\(\*StyleBox[\"\!\(xAct`xCoba`Private`a\+_\)\",\
FontColor->RGBColor[1., 0., 0.]]\)", " "}}, RowSpacings -> 0, ColumnSpacings -> 
                    0.05, GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[{-Pattern[xAct`xCoba`Private`a, 
                    Blank[Symbol]], -Pattern[xAct`xCoba`Private`basis, 
                    Blank[]]}, {
                    Pattern[xAct`xCoba`Private`a, 
                    Blank[Symbol]], 
                    Pattern[xAct`xCoba`Private`basis, 
                    Blank[]]}], Editable -> False], ":=", 
                    RowBox[{"DimOfVBundle", "[", 
                    
                    RowBox[{
                    "VBundleOfIndex", "[", "xAct`xCoba`Private`a", "]"}], 
                    "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{"\!\(xAct`xCoba`Private`i\+_\)", "#"}, {
                    " ", " "}}, RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[
                    Pattern[xAct`xCoba`Private`i, 
                    Blank[]], 
                    xAct`xTensor`Dir[
                    Pattern[xAct`xCoba`Private`expr, 
                    Blank[]]]], Editable -> False], ":=", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"xAct`xCoba`Private`ui", "=", 
                    RowBox[{"xAct`xTensor`Private`UltraindexOf", "[", 
                    RowBox[{"Dir", "[", "xAct`xCoba`Private`expr", "]"}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Delta]", 
                    StyleBox[
                    
                    GridBox[{{" ", "xAct`xCoba`Private`i"}, {
                    "xAct`xCoba`Private`ui", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    
                    xAct`xTensor`delta[-xAct`xCoba`Private`ui, 
                    xAct`xCoba`Private`i], Editable -> False], ";", 
                    RowBox[{"ReplaceIndex", "[", 
                    RowBox[{"xAct`xCoba`Private`expr", ",", 
                    
                    RowBox[{"xAct`xCoba`Private`ui", "\[Rule]", 
                    "xAct`xCoba`Private`i"}]}], "]"}]}]}], "]"}]}]}, {" "}, {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"e", 
                    StyleBox[
                    
                    GridBox[{{"#", "\!\(xAct`xCoba`Private`i\+_\)"}, {
                    " ", " "}}, RowSpacings -> 0, ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    xAct`xTensor`Basis[
                    xAct`xTensor`Dir[
                    Pattern[xAct`xCoba`Private`expr, 
                    Blank[]]], 
                    Pattern[xAct`xCoba`Private`i, 
                    Blank[]]], Editable -> False], ":=", 
                    RowBox[{"With", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"xAct`xCoba`Private`ui", "=", 
                    RowBox[{"xAct`xTensor`Private`UltraindexOf", "[", 
                    RowBox[{"Dir", "[", "xAct`xCoba`Private`expr", "]"}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    GridBox[{{"\[Delta]", 
                    StyleBox[
                    
                    GridBox[{{" ", "xAct`xCoba`Private`i"}, {
                    "xAct`xCoba`Private`ui", " "}}, RowSpacings -> 0, 
                    ColumnSpacings -> 0.05, 
                    GridFrameMargins -> {{0, 0}, {0, 0}}], FontSize -> 
                    Rational[39, 4]]}}, ColumnSpacings -> 0.05, RowAlignments -> 
                    Center], AutoSpacing -> False, ShowAutoStyles -> False], 
                    
                    xAct`xTensor`delta[-xAct`xCoba`Private`ui, 
                    xAct`xCoba`Private`i], Editable -> False], ";", 
                    RowBox[{"ReplaceIndex", "[", 
                    RowBox[{"xAct`xCoba`Private`expr", ",", 
                    
                    RowBox[{"xAct`xCoba`Private`ui", "\[Rule]", 
                    "xAct`xCoba`Private`i"}]}], "]"}]}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`Basis\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Basis represents both the type and the tensor head \
for a basis vector/covector field.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "Basis represents both the type and the tensor head for a basis \
vector/covector field.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> 
    Information`InformationValueForm[
     UpValues, xAct`xTensor`Basis, {
      xAct`xTensor`Dagger[xAct`xTensor`Basis] -> xAct`xTensor`Basis, 
       xAct`xTensor`DependenciesOfTensor[xAct`xTensor`Basis] :> {}, 
       xAct`xTensor`MasterOf[xAct`xTensor`Basis] -> Symbol, 
       xAct`xTensor`PrintAs[xAct`xTensor`Basis] -> "e", 
       xAct`xTensor`SlotsOfTensor[xAct`xTensor`Basis] :> {-All, All}, 
       xAct`xTensor`xTensorQ[xAct`xTensor`Basis] -> True, 
       xAct`xTensor`SymmetryGroupOfTensor[
         xAct`xTensor`Basis[
          Pattern[xAct`xCoba`Private`a, 
           Blank[]], 
          Pattern[xAct`xCoba`Private`b, 
           Blank[]]]] :> 
       With[{xAct`xCoba`Private`metric = 
          xAct`xTensor`Private`FirstMetricOfVBundle[
            xAct`xTensor`VBundleOfIndex[xAct`xCoba`Private`a], False]}, 
         If[xAct`xCoba`Private`metric === Null, 
          xAct`xPerm`StrongGenSet[{}, 
           xAct`xPerm`GenSet[]], 
          xAct`xTensor`SymmetryGroupOfTensor[xAct`xCoba`Private`metric]]], 
       Condition[
         Pattern[xAct`xCoba`Private`f, 
          Blank[Symbol]], xAct`xCoba`Private`f === Times][
         Pattern[xAct`xCoba`Private`expr1, 
          BlankNullSequence[]], 
         xAct`xTensor`Basis[{-Pattern[xAct`xCoba`Private`a, 
             Blank[Symbol]], -Pattern[xAct`xCoba`Private`basis, 
             Blank[]]}, {
           Pattern[xAct`xCoba`Private`b, 
            Blank[Symbol]], 
           Pattern[xAct`xCoba`Private`basis, 
            Blank[]]}], 
         Pattern[xAct`xCoba`Private`expr2, 
          BlankNullSequence[]]] :> Condition[
         xAct`xTensor`ReplaceIndex[
         xAct`xCoba`Private`expr1 
          xAct`xCoba`Private`expr2, -xAct`xCoba`Private`b -> -
           xAct`xCoba`Private`a], 
         xAct`xTensor`IsIndexOf[
         xAct`xCoba`Private`expr1 
          xAct`xCoba`Private`expr2, {-xAct`xCoba`Private`b, -
           xAct`xCoba`Private`basis}, xAct`xTensor`Basis]], Condition[
         Pattern[xAct`xCoba`Private`f, 
          Blank[Symbol]], xAct`xCoba`Private`f === Times][
         Pattern[xAct`xCoba`Private`expr1, 
          BlankNullSequence[]], 
         xAct`xTensor`Basis[{-Pattern[xAct`xCoba`Private`a, 
             Blank[Symbol]], -Pattern[xAct`xCoba`Private`basis, 
             Blank[]]}, {
           Pattern[xAct`xCoba`Private`b, 
            Blank[Symbol]], 
           Pattern[xAct`xCoba`Private`basis, 
            Blank[]]}], 
         Pattern[xAct`xCoba`Private`expr2, 
          BlankNullSequence[]]] :> Condition[
         xAct`xTensor`ReplaceIndex[
         xAct`xCoba`Private`expr1 xAct`xCoba`Private`expr2, 
          xAct`xCoba`Private`a -> xAct`xCoba`Private`b], 
         xAct`xTensor`IsIndexOf[
         xAct`xCoba`Private`expr1 xAct`xCoba`Private`expr2, {
          xAct`xCoba`Private`a, xAct`xCoba`Private`basis}, 
          xAct`xTensor`Basis]], HoldPattern[
         PatternTest[
          Pattern[xAct`xCoba`Private`covd, 
           Blank[]], xAct`xTensor`CovDQ][
          Pattern[xAct`xCoba`Private`a, 
           Blank[]]][
          xAct`xTensor`Basis[{
            Pattern[xAct`xCoba`Private`c, 
             Blank[]], -PatternTest[
              Pattern[xAct`xCoba`Private`basis, 
               Blank[]], xAct`xTensor`BasisQ]}, 
           Pattern[xAct`xCoba`Private`b, 
            Blank[Symbol]]]]] :> If[xAct`xCoba`Private`CommonDependencies[
           xAct`xCoba`Private`covd[xAct`xCoba`Private`a], {
           xAct`xCoba`Private`basis}] === {}, 0, 
         xAct`xTensor`Christoffel[xAct`xCoba`Private`covd, 
          xAct`xCoba`PDOfBasis[xAct`xCoba`Private`basis]][
         xAct`xCoba`Private`b, xAct`xCoba`Private`a, {
          xAct`xCoba`Private`c, -xAct`xCoba`Private`basis}]], HoldPattern[
         PatternTest[
          Pattern[xAct`xCoba`Private`covd, 
           Blank[]], xAct`xTensor`CovDQ][
          Pattern[xAct`xCoba`Private`a, 
           Blank[]]][
          xAct`xTensor`Basis[-Pattern[xAct`xCoba`Private`b, 
             Blank[Symbol]], {
            Pattern[xAct`xCoba`Private`c, 
             Blank[]], 
            PatternTest[
             Pattern[xAct`xCoba`Private`basis, 
              Blank[]], xAct`xTensor`BasisQ]}]]] :> 
       If[xAct`xCoba`Private`CommonDependencies[
           xAct`xCoba`Private`covd[xAct`xCoba`Private`a], {
           xAct`xCoba`Private`basis}] === {}, 0, -
         xAct`xTensor`Christoffel[xAct`xCoba`Private`covd, 
           xAct`xCoba`PDOfBasis[xAct`xCoba`Private`basis]][{
           xAct`xCoba`Private`c, xAct`xCoba`Private`basis}, 
           xAct`xCoba`Private`a, -xAct`xCoba`Private`b]], HoldPattern[
         PatternTest[
          Pattern[xAct`xCoba`Private`covd, 
           Blank[]], xAct`xTensor`CovDQ][
          Pattern[xAct`xCoba`Private`a, 
           Blank[]]][
          xAct`xTensor`Basis[
           Pattern[xAct`xCoba`Private`c, {
             Blank[], -PatternTest[
               Pattern[xAct`xCoba`Private`basisc, 
                Blank[]], xAct`xTensor`BasisQ]}], 
           Pattern[xAct`xCoba`Private`b, {
             Blank[], 
             PatternTest[
              Pattern[xAct`xCoba`Private`basisb, 
               Blank[]], xAct`xTensor`BasisQ]}]]]] :> 
       If[xAct`xCoba`Private`CommonDependencies[
           xAct`xCoba`Private`covd[xAct`xCoba`Private`a], {
           xAct`xCoba`Private`basisc, xAct`xCoba`Private`basisb}] === {}, 0, 
         xAct`xTensor`Christoffel[
          xAct`xCoba`PDOfBasis[xAct`xCoba`Private`basisb], 
          xAct`xCoba`PDOfBasis[xAct`xCoba`Private`basisc]][
         xAct`xCoba`Private`b, xAct`xCoba`Private`a, xAct`xCoba`Private`c]], 
       xAct`xCoba`ToCTensor[xAct`xTensor`Basis, {-xAct`xCoba`CBasis[
            Pattern[xAct`xCoba`Private`basis, 
             Blank[]], 
            Pattern[xAct`xCoba`Private`matrix, 
             Blank[]]], 
          Pattern[xAct`xCoba`Private`basis, 
           Blank[]]}, 0] :> xAct`xCoba`CTensor[
         Inverse[
         xAct`xCoba`Private`matrix], {-
          xAct`xCoba`CBasis[
           xAct`xCoba`Private`basis, xAct`xCoba`Private`matrix], 
          xAct`xCoba`Private`basis}, 0], 
       xAct`xCoba`ToCTensor[
        xAct`xTensor`Basis, {-Pattern[xAct`xCoba`Private`basis, 
            Blank[]], 
          xAct`xCoba`CBasis[
           Pattern[xAct`xCoba`Private`basis, 
            Blank[]], 
           Pattern[xAct`xCoba`Private`matrix, 
            Blank[]]]}, 0] :> 
       xAct`xCoba`CTensor[
        xAct`xCoba`Private`matrix, {-xAct`xCoba`Private`basis, 
          xAct`xCoba`CBasis[
          xAct`xCoba`Private`basis, xAct`xCoba`Private`matrix]}, 0], 
       xAct`xCoba`ToCTensor[xAct`xTensor`Basis, {-xAct`xCoba`CBasis[
            Pattern[xAct`xCoba`Private`basis, 
             Blank[]], 
            Pattern[xAct`xCoba`Private`matrix1, 
             Blank[]]], 
          xAct`xCoba`CBasis[
           Pattern[xAct`xCoba`Private`basis, 
            Blank[]], 
           Pattern[xAct`xCoba`Private`matrix2, 
            Blank[]]]}, 0] :> xAct`xCoba`CTensor[
         Dot[
          Inverse[xAct`xCoba`Private`matrix1], xAct`xCoba`Private`matrix2], {-
          xAct`xCoba`CBasis[
           xAct`xCoba`Private`basis, xAct`xCoba`Private`matrix1], 
          xAct`xCoba`CBasis[
          xAct`xCoba`Private`basis, xAct`xCoba`Private`matrix2]}, 0]}], 
    "DownValues" -> 
    Information`InformationValueForm[
     DownValues, xAct`xTensor`Basis, {
      xAct`xTensor`Basis[-Pattern[xAct`xCoba`Private`a, 
           Blank[Symbol]], 
         Pattern[xAct`xCoba`Private`b, 
          Blank[Symbol]]] :> 
       xAct`xTensor`delta[-xAct`xCoba`Private`a, xAct`xCoba`Private`b], 
       xAct`xTensor`Basis[
         Pattern[xAct`xCoba`Private`a, 
          Blank[Symbol]], 
         PatternTest[
          Pattern[xAct`xCoba`Private`b, 
           Blank[]], xAct`xTensor`DownIndexQ]] :> 
       xAct`xTensor`Private`SymmetryOfIndex[xAct`xCoba`Private`a] 
        xAct`xTensor`Basis[xAct`xCoba`Private`b, xAct`xCoba`Private`a], 
       xAct`xTensor`Basis[
         Pattern[xAct`xCoba`Private`a, {
           Blank[], 
           PatternTest[
            Blank[], xAct`xTensor`BasisQ]}], 
         PatternTest[
          Pattern[xAct`xCoba`Private`b, 
           Blank[]], xAct`xTensor`DownIndexQ]] :> 
       xAct`xTensor`Private`SymmetryOfIndex[xAct`xCoba`Private`a] 
        xAct`xTensor`Basis[xAct`xCoba`Private`b, xAct`xCoba`Private`a], 
       xAct`xTensor`Basis[
         Pattern[xAct`xCoba`Private`a, 
          PatternTest[
           Blank[], xAct`xTensor`BasisQ][
           Blank[]]], 
         PatternTest[
          Pattern[xAct`xCoba`Private`b, 
           Blank[]], xAct`xTensor`DownIndexQ]] :> 
       xAct`xTensor`Private`SymmetryOfIndex[xAct`xCoba`Private`a] 
        xAct`xTensor`Basis[xAct`xCoba`Private`b, xAct`xCoba`Private`a], 
       xAct`xTensor`Basis[
         Pattern[xAct`xCoba`Private`a, 
          Alternatives[
           Blank[Symbol], {
            Blank[], 
            PatternTest[
             Blank[], xAct`xTensor`BasisQ]}]], 
         Pattern[xAct`xCoba`Private`b, 
          Alternatives[
           Blank[Symbol], {
            Blank[], 
            PatternTest[
             Blank[], xAct`xTensor`BasisQ]}]]] :> 
       xAct`xTensor`Private`FirstMetricOfVBundle[
         xAct`xTensor`VBundleOfIndex[xAct`xCoba`Private`a], True][
        xAct`xCoba`Private`a, xAct`xCoba`Private`b], xAct`xTensor`Basis[
         Pattern[xAct`xCoba`Private`a, 
          Alternatives[-Blank[Symbol], {
            Blank[], -PatternTest[
              Blank[], xAct`xTensor`BasisQ]}]], 
         Pattern[xAct`xCoba`Private`b, 
          Alternatives[-Blank[Symbol], {
            Blank[], -PatternTest[
              Blank[], xAct`xTensor`BasisQ]}]]] :> 
       xAct`xTensor`Private`FirstMetricOfVBundle[
         xAct`xTensor`VBundleOfIndex[xAct`xCoba`Private`a], True][
        xAct`xCoba`Private`a, xAct`xCoba`Private`b], xAct`xTensor`Basis[{
          Pattern[xAct`xCoba`Private`i, 
           Blank[Integer]], -Pattern[xAct`xCoba`Private`basis, 
            Blank[]]}, {
          Pattern[xAct`xCoba`Private`j, 
           Blank[Integer]], 
          Pattern[xAct`xCoba`Private`basis, 
           Blank[]]}] :> 
       KroneckerDelta[xAct`xCoba`Private`i, xAct`xCoba`Private`j], 
       xAct`xTensor`Basis[{-Pattern[xAct`xCoba`Private`a, 
            Blank[Symbol]], -Pattern[xAct`xCoba`Private`basis, 
            Blank[]]}, {
          Pattern[xAct`xCoba`Private`a, 
           Blank[Symbol]], 
          Pattern[xAct`xCoba`Private`basis, 
           Blank[]]}] :> xAct`xTensor`DimOfVBundle[
         xAct`xTensor`VBundleOfIndex[xAct`xCoba`Private`a]], 
       xAct`xTensor`Basis[
         Pattern[xAct`xCoba`Private`i, 
          Blank[]], 
         xAct`xTensor`Dir[
          Pattern[xAct`xCoba`Private`expr, 
           Blank[]]]] :> 
       With[{xAct`xCoba`Private`ui = xAct`xTensor`Private`UltraindexOf[
            xAct`xTensor`Dir[xAct`xCoba`Private`expr]]}, 
         xAct`xTensor`delta[-xAct`xCoba`Private`ui, xAct`xCoba`Private`i]; 
         xAct`xTensor`ReplaceIndex[
          xAct`xCoba`Private`expr, xAct`xCoba`Private`ui -> 
           xAct`xCoba`Private`i]], xAct`xTensor`Basis[
         xAct`xTensor`Dir[
          Pattern[xAct`xCoba`Private`expr, 
           Blank[]]], 
         Pattern[xAct`xCoba`Private`i, 
          Blank[]]] :> 
       With[{xAct`xCoba`Private`ui = xAct`xTensor`Private`UltraindexOf[
            xAct`xTensor`Dir[xAct`xCoba`Private`expr]]}, 
         xAct`xTensor`delta[-xAct`xCoba`Private`ui, xAct`xCoba`Private`i]; 
         xAct`xTensor`ReplaceIndex[
          xAct`xCoba`Private`expr, xAct`xCoba`Private`ui -> 
           xAct`xCoba`Private`i]]}], "SubValues" -> None, "DefaultValues" -> 
    None, "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {Protected}, "FullName" -> "xAct`xTensor`Basis"|>, 
   False]]], "Output",
 CellLabel->
  "Out[47]=",ExpressionUUID->"a26a339d-8673-4155-8e8d-74b5b427807f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VBundleOfIndex", "[", "A", "]"}]], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"4fbe4b6f-eb4a-482a-9672-43d9a73b84df"],

Cell[BoxData[
 InterpretationBox[
  StyleBox["TestBundle",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`TestBundle,
  Editable->False]], "Output",
 CellLabel->
  "Out[48]=",ExpressionUUID->"c93f3a01-0bd4-4968-83b6-f9d8858438e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"VBundleOfIndex", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "Ba"}], "}"}], "]"}], "===", 
  RowBox[{"First", "@", "$VBundles"}]}]], "Input",
 CellLabel->"In[49]:=",ExpressionUUID->"a7840b95-ff30-4fcc-8cc3-c84aed44e4dc"],

Cell[BoxData["True"], "Output",
 CellLabel->
  "Out[49]=",ExpressionUUID->"85715a32-80d4-401c-93ca-bee4bac4fdf2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConformalWeight", "[", 
  RowBox[{"Basis", "[", 
   RowBox[{
    RowBox[{"-", "\[Mu]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "Ba"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[50]:=",ExpressionUUID->"4388dbd9-f530-4360-8717-af4506742955"],

Cell[BoxData["0"], "Output",
 CellLabel->
  "Out[50]=",ExpressionUUID->"1ec5b2df-0dd1-4807-aca0-55089103c534"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Basis", "[", 
  RowBox[{"\[Mu]", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "Ba"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "G"}], "]"}], "[", "%", "]"}]}], "Input",
 CellLabel->"In[51]:=",ExpressionUUID->"00bff594-4862-4239-bb31-9c0498b07693"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"e", 
      StyleBox[GridBox[{
         {" ", "\[Mu]"},
         {
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]], " "}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Basis[{1, -$CellContext`Ba}, $CellContext`\[Mu]],
  Editable->False]], "Output",
 CellLabel->"Out[51]=",ExpressionUUID->"d388cfcd-ba63-42a0-bfe2-ea7d78bc909b"],

Cell[BoxData[
 TemplateBox[{
  "ConformalRules", "unknown", 
   "\"Unknown \\!\\(\\*RowBox[{\\\"\\\\\\\"conformal relation \
of\\\\\\\"\\\"}]\\) \\!\\(\\*RowBox[{\\\"g\\\"}]\\).\"", 2, 52, 10, 
   31762299904679089286, "Local", "xAct`xTensor`ConformalRules"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[51]:=",ExpressionUUID->"9e77e4e4-2f8e-48f7-99bf-9a3616d471c3"],

Cell[BoxData[
 TemplateBox[{
  "Christoffel", "unknown", 
   "\"Unknown \\!\\(\\*RowBox[{\\\"\\\\\\\"covariant derivative\\\\\\\"\\\"}]\
\\) \\!\\(\\*RowBox[{\\\"None\\\"}]\\).\"", 2, 52, 11, 31762299904679089286, 
   "Local", "xAct`xTensor`Christoffel"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[51]:=",ExpressionUUID->"b694988b-459b-43f4-8f6c-b747639710ad"],

Cell[BoxData[
 TemplateBox[{
  "Throw", "nocatch", 
   "\"Uncaught \\!\\(\\*RowBox[{\\\"Throw\\\", \\\"[\\\", \\\"Null\\\", \\\"]\
\\\"}]\\) returned to top level.\"", 2, 52, 12, 31762299904679089286, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[51]:=",ExpressionUUID->"110c3baf-3a91-4cef-93bc-632112017ef0"],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Throw", "[", "Null", "]"}], "]"}]], "Output",
 CellLabel->
  "Out[52]=",ExpressionUUID->"824dc2d0-50ce-41d0-8fce-4fd4dd5ecb63"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Basis", "[", 
  RowBox[{
   RowBox[{"-", "\[Mu]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "Ba"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConformalTransformation", "[", 
   RowBox[{"g", ",", "G"}], "]"}], "[", "%", "]"}]}], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"23a014de-e625-4514-83d7-fba50fa36dba"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"g", 
      StyleBox[GridBox[{
         {" ", " "},
         {"\[Mu]", 
          StyleBox["1",
           FontColor->RGBColor[1., 0., 0.]]}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "Rows" -> {{
             Offset[0.]}}}],
       FontSize->Rational[39, 4]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`g[-$CellContext`\[Mu], {1, -$CellContext`Ba}],
  Editable->False]], "Output",
 CellLabel->"Out[53]=",ExpressionUUID->"587a1c48-4dac-47ba-898a-fd6b5d3efa67"],

Cell[BoxData[
 TemplateBox[{
  "ConformalRules", "unknown", 
   "\"Unknown \\!\\(\\*RowBox[{\\\"\\\\\\\"conformal relation \
of\\\\\\\"\\\"}]\\) \\!\\(\\*RowBox[{\\\"g\\\"}]\\).\"", 2, 54, 13, 
   31762299904679089286, "Local", "xAct`xTensor`ConformalRules"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[53]:=",ExpressionUUID->"ce2489d2-89df-4f41-8d6f-0dae7a0bef2a"],

Cell[BoxData[
 TemplateBox[{
  "Christoffel", "unknown", 
   "\"Unknown \\!\\(\\*RowBox[{\\\"\\\\\\\"covariant derivative\\\\\\\"\\\"}]\
\\) \\!\\(\\*RowBox[{\\\"None\\\"}]\\).\"", 2, 54, 14, 31762299904679089286, 
   "Local", "xAct`xTensor`Christoffel"},
  "MessageTemplate2"]], "Message", "MSG",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[53]:=",ExpressionUUID->"ace2d812-441f-4cce-a93f-c1641c2c7b80"],

Cell[BoxData[
 TemplateBox[{
  "Throw", "nocatch", 
   "\"Uncaught \\!\\(\\*RowBox[{\\\"Throw\\\", \\\"[\\\", \\\"Null\\\", \\\"]\
\\\"}]\\) returned to top level.\"", 2, 54, 15, 31762299904679089286, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellLabel->
  "Lors de l\[CloseCurlyQuote]\[EAcute]valuation de \
In[53]:=",ExpressionUUID->"184b4334-1775-4f43-88de-d888255a145f"],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Throw", "[", "Null", "]"}], "]"}]], "Output",
 CellLabel->
  "Out[54]=",ExpressionUUID->"66e5d7f7-d4e1-41bc-a020-f30565bf5751"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{912, 847},
WindowMargins->{{Automatic, 228}, {Automatic, 0}},
Visible->True,
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[{
      ButtonBox[
      "\"\[Dagger]\"", ButtonFunction :> Exit[], Appearance -> Automatic, 
       Evaluator -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"\[RightTriangle]\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluatorStart"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"\[RightTriangle]\[RightTriangle]\"", ButtonFunction :> 
       FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluateNotebook"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox["\"EvalInit\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["EvaluateInitialization"]], Evaluator -> None,
        Appearance -> Automatic, Method -> "Preemptive"], 
      ButtonBox[
      "\"Init\"", 
       ButtonFunction :> (Module[{Utility`Toolbar`cell = NotebookSelection[
             SelectedNotebook[]], Utility`Toolbar`isInit}, 
          Utility`Toolbar`isInit = ReplaceAll[InitializationCell, 
             Options[Utility`Toolbar`cell, InitializationCell]]; If[
            TrueQ[
             Or[
             Utility`Toolbar`isInit == True, Utility`Toolbar`isInit == On]], 
            SetOptions[Utility`Toolbar`cell, InitializationCell -> False], 
            SetOptions[Utility`Toolbar`cell, InitializationCell -> True]]]; 
        Null), Appearance -> Automatic, Evaluator -> Automatic, Method -> 
       "Preemptive"], 
      ButtonBox["\"DeInit\"", ButtonFunction :> SetOptions[
         NotebookSelection[
          SelectedNotebook[]], InitializationCell -> False], Appearance -> 
       Automatic, Evaluator -> Automatic, Method -> "Preemptive"], 
      ButtonBox["\"\[DeleteKey]\"", ButtonFunction :> FrontEnd`FrontEndExecute[
         FrontEnd`FrontEndToken["DeleteGeneratedCells"]], Evaluator -> None, 
       Appearance -> Automatic, Method -> "Preemptive"]}, "Row", 
     DisplayFunction -> (
      RowBox[{#, "\[InvisibleSpace]", #2, "\[InvisibleSpace]", #3, 
        "\[InvisibleSpace]", #4, "\[InvisibleSpace]", #5, 
        "\[InvisibleSpace]", #6, "\[InvisibleSpace]", #7}]& ), 
     InterpretationFunction -> (RowBox[{"Row", "[", 
        RowBox[{"{", 
          RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7}], 
          "}"}], "]"}]& )]], "DockedCell"]},
PrivateNotebookOptions->{"FileOutlineCache"->False},
ShowSelection->True,
TrackCellChangeTimes->False,
FrontEndVersion->"14.1 pour Mac OS X ARM (64-bit) (July 16, 2024)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "PastelColor.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"86c13e78-029e-4d24-a525-a1a5cc7b3a95"
]

